import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React, { useState, useCallback } from 'react';
import { Link } from 'react-router-dom';

import { cn } from '@bem-react/classname';

import Button from '@components/Button';
import Icon from '@components/Icon';
import Image from '@components/Image';
import { useBillsRestartSearch } from '@hooks/useBillsRestartSearch';
import useConstants from '@hooks/useConstants';
import useMetrika from '@hooks/useMetrika';
import useRoutes from '@hooks/useRoutes';

import './NoBills.css';

import GoodIcon from './assets/good.svg';

const i18n = i18nFactory(keyset);

const cnGibddScreenListNoBills = cn('GibddScreenListNoBills');

export type GibddScreenListNoBillsProps = {
    header: string;
}

export const GibddScreenListNoBills: React.FC<GibddScreenListNoBillsProps> = ({ header }) => {
    const metrika = useMetrika();
    const [restartActivated, setRestartActivated] = useState(false);
    const restartSearchFn = useBillsRestartSearch();

    const routes = useRoutes();

    const { flags: { billsOnly } } = useConstants();

    const restartSearch = useCallback(
        () => {
            metrika.reachGoal('click_search_fines', {});
            setRestartActivated(true);
            restartSearchFn();
        },
        [metrika, setRestartActivated, restartSearchFn],
    );

    return (
        <div className={cnGibddScreenListNoBills()}>
            <Image className={cnGibddScreenListNoBills('Icon')} src={GoodIcon} />
            <h2 className={cnGibddScreenListNoBills('Header')}>{header}</h2>
            <Button
                onClick={restartSearch}
                view="default"
                disabled={restartActivated}
                progress={restartActivated}
                className={cnGibddScreenListNoBills('Button')}
                size="l">
                {i18n('Искать снова')}
            </Button>
            {billsOnly &&
                <Link to={routes.gibddSettings()}>
                    <Icon className={cnGibddScreenListNoBills('Settings')} name="settings" />
                </Link>
            }
        </div>
    );
};
