import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React, { useState } from 'react';

import { cn } from '@bem-react/classname';
import { classNames } from '@yandex-int/tap-components/helpers';

import { useInterval } from '@hooks/useInterval';

import './index.css';

const cnGibddScreenLoaderCarousel = cn('GibddScreenLoaderCarousel');
const CAROUSEL_INTERVAL = 5000;

export type GibddScreenLoaderCarouselProps = {
    className?: string;
}

const i18n = i18nFactory(keyset);

export const GibddScreenLoaderCarousel: React.FC<GibddScreenLoaderCarouselProps> = ({ className }) => {
    // TODO: Заменить факты
    const [facts] = useState([
        '3 января 1683 года Петр 1 издал указ о правилах дорожного движения',
        'В 1812 году в Москве уже действовали самые настоящие правила',
    ]);
    const [index, setIndex] = useState(0);
    const [prevIndex, setPrevIndex] = useState(-1);

    useInterval(() => {
        if (index + 1 === facts.length) {
            setIndex(0);
            setPrevIndex(facts.length - 1);
        } else {
            setIndex(index + 1);
            setPrevIndex(index);
        }
    }, CAROUSEL_INTERVAL);

    return (
        <div className={classNames(cnGibddScreenLoaderCarousel(), className)}>
            <h2 className={cnGibddScreenLoaderCarousel('header')}>{i18n('Интересные факты')}</h2>
            <div className={cnGibddScreenLoaderCarousel('fact-container')}>
                {facts.map((fact, factIndex) => (
                    <span key={fact} className={cnGibddScreenLoaderCarousel('fact', { active: index === factIndex, prev: factIndex === prevIndex, curr: factIndex === index })}>{fact}</span>
                ))}
            </div>
        </div>
    );
};
