import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React from 'react';
import { Link } from 'react-router-dom';

import { cn } from '@bem-react/classname';

import Icon from '@components/Icon';
import IconButton from '@components/IconButton';
import Spin from '@components/Spin';
import useConstants from '@hooks/useConstants';
import useRoutes from '@hooks/useRoutes';

import { GibddScreenLoaderCarousel } from './Carousel';

import './index.css';

const cnGibddScreenLoader = cn('GibddScreenLoader');

const i18n = i18nFactory(keyset);

export type GibddScreenLoaderType = 'default' | 'simple' | 'overloaded';

export type GibddScreenLoaderProps = {
    type: GibddScreenLoaderType;
}

export const GibddScreenLoader: React.FC<GibddScreenLoaderProps> = ({ type = 'default' }) => {
    const routes = useRoutes();
    const { flags: { billsOnly } } = useConstants();

    return (
        <div className={cnGibddScreenLoader()}>
            <div className={cnGibddScreenLoader('controls')}>
                {!billsOnly &&
                    <Link to={routes.main}>
                        <IconButton type="filled">
                            <Icon size="s" name="arrowleft" />
                        </IconButton>
                    </Link>
                }
            </div>
            <Spin size="m" progress />
            {type !== 'overloaded' &&
                <React.Fragment>
                    <h1 className={cnGibddScreenLoader('header')}>{i18n('Ищем штрафы')}</h1>
                    {type !== 'simple' && <span className={cnGibddScreenLoader('hint')}>{i18n('Это займет около 20 секунд')}</span>}
                    {type !== 'simple' && <GibddScreenLoaderCarousel className={cnGibddScreenLoader('carousel')} />}
                </React.Fragment>
            }
            {type === 'overloaded' &&
                <h1 className={cnGibddScreenLoader('header')}>
                    {i18n('Поиск затянулся. Мы пришлем уведомление, если найдем штрафы')}
                </h1>
            }
        </div>
    );
};
