import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React from 'react';
import { Link } from 'react-router-dom';

import { cn } from '@bem-react/classname';

import Icon from '@components/Icon';
import IconButton from '@components/IconButton';
import useConstants from '@hooks/useConstants';
import useRoutes from '@hooks/useRoutes';

import AddDocuments from './AddDocuments';

import './index.css';

const cnGibddScreenOnboarding = cn('GibddScreenOnboarding');

const i18n = i18nFactory(keyset);

export const GibddScreenOnboarding: React.FC = () => {
    const routes = useRoutes();
    const { flags: { billsOnly } } = useConstants();

    return (
        <>
            {!billsOnly &&
                <Link to={routes.main}>
                    <IconButton type="filled">
                        <Icon size="s" name="arrowleft" />
                    </IconButton>
                </Link>
            }
            <h1 className={cnGibddScreenOnboarding('header', { billsOnly })}>
                {i18n('Чтобы оплатить штрафы, добавьте номера СТС и ВУ')}
            </h1>
            <AddDocuments />
        </>
    );
};
