import React, { useEffect } from 'react';

import { cn } from '@bem-react/classname';

import { billsPay3dsCompleteSource, billsPay3dsCompleteType, billsPay3dsFrameUrl } from '@client/constants';
import useConstants from '@hooks/useConstants';
import { usePostMessage } from '@hooks/usePostMessage';
import { IBillPaymentAuth3ds } from '@src/types';

import './index.css';

const cnBillsAuth3ds = cn('BillsAuth3ds');

interface BillsAuth3dsProps {
    authData: IBillPaymentAuth3ds;
    onLoad?: () => void;
    onComplete: () => void;
}

const getHttpsUrl = (url: string) => {
    if (url.startsWith('http://')) {
        return url.slice(0, 4) + 's' + url.slice(4);
    }

    return url;
};

export const BillsAuth3ds: React.FC<BillsAuth3dsProps> = React.memo(({
    authData,
    onLoad,
    onComplete,
}) => {
    const { url, method } = authData;
    const onPostMessage = usePostMessage();
    const { platform: { isTouch } } = useConstants();

    useEffect(() => {
        return onPostMessage((message) => {
            if (message.source === billsPay3dsCompleteSource && message.type === billsPay3dsCompleteType) {
                onComplete();
            }
        });
    }, [onPostMessage, onComplete]);

    return (
        <div className={cnBillsAuth3ds({ touch: isTouch })}>
            <iframe
                title="3DS"
                src={`${billsPay3dsFrameUrl()}/?src=${encodeURIComponent(getHttpsUrl(url))}&method=${method}`}
                name="frame-3ds"
                onLoad={onLoad}
                frameBorder="0"
                scrolling="auto"
                data-label="3ds--frame"
            />
        </div>
    );
});
