import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React from 'react';

import { cn } from '@bem-react/classname';

import Button from '@components/Button';
import Image from '@components/Image';
import Modal from '@components/Modal';
import Spin from '@components/Spin';

import CancelSvg from './assets/cancel.svg';
import FailSvg from './assets/fail.svg';
import SuccessSvg from './assets/success.svg';

import './index.css';

const cnBillPaymentStatus = cn('BillPaymentStatus');

const i18n = i18nFactory(keyset);

interface BillPaymentStatusProps {
    status: 'pending' | 'cancel' | 'success' | 'fail';
    onClose?: () => void;
}

export const BillPaymentStatus: React.FC<BillPaymentStatusProps> = ({
    status,
    onClose,
}) => {
    if (status === 'cancel') {
        return (
            <Modal visible onClose={onClose} className={cnBillPaymentStatus('Modal')} closeIcon="closeGray">
                <div className={cnBillPaymentStatus()}>
                    <Image className={cnBillPaymentStatus('Icon')} src={CancelSvg} />
                    <h2 className={cnBillPaymentStatus('Title')}>{i18n('Оплата отменена')}</h2>
                    <div className={cnBillPaymentStatus('Button')}>
                        <Button view="default" size="xl" pin="round-m" width="max" onClick={onClose}>
                            {i18n('Закрыть')}
                        </Button>
                    </div>
                </div>
            </Modal>
        );
    }

    if (status === 'fail') {
        return (
            <Modal visible onClose={onClose} className={cnBillPaymentStatus('Modal')} closeIcon="closeGray">
                <div className={cnBillPaymentStatus()}>
                    <Image className={cnBillPaymentStatus('Icon')} src={FailSvg} />
                    <h2 className={cnBillPaymentStatus('Title')}>{i18n('Оплата не прошла')}</h2>
                    <div className={cnBillPaymentStatus('Button')}>
                        <Button view="default" size="xl" pin="round-m" width="max" onClick={onClose}>
                            {i18n('Закрыть')}
                        </Button>
                    </div>
                </div>
            </Modal>
        );
    }

    if (status === 'success') {
        return (
            <Modal visible onClose={onClose} className={cnBillPaymentStatus('Modal')} closeIcon="closeGray">
                <div className={cnBillPaymentStatus()}>
                    <Image className={cnBillPaymentStatus('Icon')} src={SuccessSvg} />
                    <h2 className={cnBillPaymentStatus('Title')}>{i18n('Штраф оплачен')}</h2>
                    <div className={cnBillPaymentStatus('Button')}>
                        <Button view="default" size="xl" pin="round-m" width="max" onClick={onClose}>
                            {i18n('Отлично')}
                        </Button>
                    </div>
                </div>
            </Modal>
        );
    }

    return (
        <Modal visible className={cnBillPaymentStatus('Modal')}>
            <div className={cnBillPaymentStatus()}>
                <div className={cnBillPaymentStatus('Spinner')}>
                    <Spin size="m" progress />
                </div>
            </div>
        </Modal>
    );
};
