import React from 'react';

import Modal from '@components/Modal';
import { useSelector } from '@hooks/redux';
import { useBillsPayment } from '@hooks/useBillsPayment';
import { useBillsPaymentPolling } from '@hooks/useBillsPaymentPolling';

import { BillsAuth3ds } from './Auth3ds';
import { BillPaymentStatus } from './Status';

export const BillsPayment: React.FC = () => {
    const payment = useSelector((state) => state.bills.payment);
    const { completePaymentAuth, resetPayment } = useBillsPayment();

    useBillsPaymentPolling();

    if (payment.state === 'initial') {
        return null;
    }

    if (payment.state === 'cancel') {
        return <BillPaymentStatus status="cancel" onClose={resetPayment} />;
    }

    if (payment.state === 'success') {
        return <BillPaymentStatus status="success" onClose={resetPayment} />;
    }

    if (payment.state === 'fail') {
        return <BillPaymentStatus status="fail" onClose={resetPayment} />;
    }

    if (payment.state === 'auth-3ds') {
        return (
            <Modal visible onClose={resetPayment} closeIcon="closeGray">
                <BillsAuth3ds
                    authData={payment.auth3ds}
                    onComplete={completePaymentAuth}
                />
            </Modal>
        );
    }

    return <BillPaymentStatus status="pending" />;
};
