import React from 'react';
import { Link } from 'react-router-dom';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import Icon from '@components/Icon';
import IconButton from '@components/IconButton';
import useRoutes from '@hooks/useRoutes';
import { IDocument } from '@src/types';

import { getNormalizedDocName, getIconNameByType, getNormalizeDocumentValue } from '../GibddScreenSettings.utils';

import './GibddScreenSettings-Document.css';

export const cnGibddScreenSettingsDocument = cn('GibddSettingsScreenDocument');

export interface IGibddScreenSettingsDocumentProps extends IClassNameProps {
    item: IDocument;
}

export const GibddScreenSettingsDocument: React.FC<IGibddScreenSettingsDocumentProps> = ({
    className,
    item,
}) => {
    const routes = useRoutes();

    return (
        <div className={cnGibddScreenSettingsDocument(null, [className])}>
            <Icon className={cnGibddScreenSettingsDocument('Tile')} name={getIconNameByType(item.type)} width={44} height={44} />
            <div className={cnGibddScreenSettingsDocument('Value')}>
                <p>{`${getNormalizedDocName(item.type)} ${getNormalizeDocumentValue(item)}`}</p>
            </div>
            <Link to={routes.gibddSettingsEditDocument(item.id)}>
                <IconButton className={cnGibddScreenSettingsDocument('Edit')}>
                    <Icon name="edit" width={24} height={24} />
                </IconButton>
            </Link>
        </div>
    );
};
