import React from 'react';
import { useParams } from 'react-router';

import Page from '@components/Page';
import { IDocumentType } from '@src/types';

import { DocumentForm } from './DocumentForm';

export type DocumentFormProps = {
    type?: IDocumentType;
}

const DocumentFormRoute: React.FC<DocumentFormProps> = ({ type }) => {
    const { id } = useParams<{ id?: string; }>();

    return (
        <Page>
            <DocumentForm id={id} addDocumentType={type} />
        </Page>
    );
};

export default DocumentFormRoute;
