import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';

import { getMaskedValue } from '@client/helpers/mask';
import { IDocument, IDocumentType } from '@src/types';

const i18n = i18nFactory(keyset);

export const getIconNameByType = (type: IDocumentType) => {
    switch (type) {
        case 'DRIVER_LICENSE':
            return 'driverLicense';
        case 'VEHICLE_REGISTRATION_CERTIFICATE':
            return 'car';
        default:
            return 'driverLicense';
    }
};

export const getNormalizedDocName = (type: IDocumentType) => {
    switch (type) {
        case 'DRIVER_LICENSE':
            return i18n('ВУ');
        case 'VEHICLE_REGISTRATION_CERTIFICATE':
            return i18n('СТС');
        default:
            return '';
    }
};

export const getPlaceholderByDocType = (type: IDocumentType) => {
    switch (type) {
        case 'DRIVER_LICENSE':
            return '00 00 000000';
        case 'VEHICLE_REGISTRATION_CERTIFICATE':
            return '00 АА 000000';
        default:
            return '00 00 000000';
    }
};

export const getMaskByDocType = (_type: IDocumentType) => {
    return [
        '00 АА 000000',
        '00 00 000000',
        '00 аа 000000',
        // для возможности изменения номера с буквами в центре
        '00 А0 000000',
        '00 0А 000000',
        '00 а0 000000',
        '00 0а 000000',
    ];
};

export const getPatternByDocType = (_type: IDocumentType) => {
    return /^(\d[1-9]|[1-9]\d) ([А-Яа-я]{2}|\d{2}) \d{6}$/i;
};

export const getNormalizeDocumentValue = (document: IDocument) => {
    return getMaskedValue(document.value, getMaskByDocType(document.type)).toUpperCase();
};
