import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React, { useMemo } from 'react';
import { Link } from 'react-router-dom';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';
import { Divider } from '@yandex-lego/components/Divider';

import Icon from '@components/Icon';
import IconButton from '@components/IconButton';
import useRoutes from '@hooks/useRoutes';
import { IDocument, IDocumentType } from '@src/types';

import { GibddScreenSettingsDocument } from '../Document/GibddScreenSettings-Document';
import { getNormalizedDocName } from '../GibddScreenSettings.utils';

import './GibddScreenSettings-Group.css';

export const cnGibddScreenSettingsGroup = cn('GibddScreenSettingsGroup');
export interface IGibddScreenSettingsGroupProps extends IClassNameProps {
    type: IDocumentType;
    items: IDocument[];
}

const i18n = i18nFactory(keyset);

const getTitleByType = (type: IDocumentType) => {
    switch (type) {
        case 'DRIVER_LICENSE':
            return i18n('Водители');
        case 'VEHICLE_REGISTRATION_CERTIFICATE':
            return i18n('Машины');
    }
};

export const GibddScreenSettingsGroup: React.FC<IGibddScreenSettingsGroupProps> = ({
    className,
    type,
    items,
}) => {
    const routes = useRoutes();
    const itemsList = useMemo(() => {
        const docsItems = items.reduce<JSX.Element[]>((acc, item, index) => {
            acc.push(
                <GibddScreenSettingsDocument
                    key={index}
                    item={item}
                />,
            );

            return acc;
        }, []);

        if (docsItems.length > 0) {
            docsItems.push(...[
                <Divider key={docsItems.length + 1} className={cnGibddScreenSettingsGroup('Divider')} size={1} color="#e6e9f0" />,
            ]);
        }

        return docsItems;
    }, [items]);

    return (
        <div className={cnGibddScreenSettingsGroup({ type }, [className])}>
            <div className={cnGibddScreenSettingsGroup('Header')}>
                {getTitleByType(type)}
            </div>
            <div className={cnGibddScreenSettingsGroup('Main')}>
                {itemsList}
                <Link className={cnGibddScreenSettingsGroup('AddLink')} to={routes.gibddSettingsAddDocument(type)}>
                    <div className={cnGibddScreenSettingsGroup('Add')}>
                        <IconButton className={cnGibddScreenSettingsGroup('AddTile')} type="filled">
                            <Icon name="add" />
                        </IconButton>
                        <div className={cnGibddScreenSettingsGroup('AddValue')}>
                            {`${i18n('Добавить номер')} ${getNormalizedDocName(type)}`}
                        </div>
                    </div>
                </Link>
            </div>
        </div>
    );
};
