import React from 'react';
import { Link } from 'react-router-dom';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import Icon from '@components/Icon';
import IconButton from '@components/IconButton';
import useRoutes from '@hooks/useRoutes';

export const cnGibddScreenSettingsHeader = cn('GibddScreenSettingsHeader');

export type IGibddScreenSettingsHeaderProps = IClassNameProps;

export const GibddScreenSettingsHeader: React.FC<IGibddScreenSettingsHeaderProps> = ({
    className,
}) => {
    const routes = useRoutes();

    return (
        <div className={cnGibddScreenSettingsHeader(null, [className])}>
            <Link to={routes.gibdd()}>
                <IconButton type="filled">
                    <Icon size="s" name="arrowleft" />
                </IconButton>
            </Link>
        </div>
    );
};

export default GibddScreenSettingsHeader;
