import React from 'react';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import { useSelector } from '@hooks/redux';
import { IDocument, IDocumentType } from '@src/types';

import { GibddScreenSettingsGroup } from '../Group';

const cnGibddScreenSettings = cn('GibddScreenSettingsList');

export interface IGibddScreenSettingsListProps extends IClassNameProps {
    header?: React.ReactNode;
    footer?: React.ReactNode;
}

export const GibddScreenSettingsList: React.FC<IGibddScreenSettingsListProps> = ({
    className,
}) => {
    const docList = useSelector((state) => state.bills.documents.list);

    const docGroups = docList.reduce<Map<IDocumentType, IDocument[]>>((acc, doc) => {
        acc.set(doc.type, (acc.get(doc.type) || []).concat(doc));

        return acc;
    }, new Map<IDocumentType, IDocument[]>([['VEHICLE_REGISTRATION_CERTIFICATE', []], ['DRIVER_LICENSE', []]]));

    const groups = [];

    for (const [type, docs] of docGroups.entries()) {
        groups.push(
            <GibddScreenSettingsGroup
                key={type}
                type={type}
                items={docs}
            />,
        );
    }

    return (
        <div className={cnGibddScreenSettings(null, [className])}>
            {groups}
        </div>
    );
};
