import React from 'react';

import { formatPrice } from '@client/helpers/number';
import type { OrderDetail } from '@client/helpers/order';

import styles from './index.module.css';

import { getDetailName } from '../../helper';

interface Props {
    data: OrderDetail;
    created: string;
    refunded?: boolean;
}

const Detail: React.FC<Props> = ({ data, created, refunded }) => {
    return (
        <div className={styles.detail}>
            <div className={styles.detail__name}>{getDetailName(data, created)}</div>
            <div className={styles.detail__price}>
                {formatPrice(data.price, data.currency, refunded, { roundIfNeeded: false, signed: false })}
            </div>
        </div>
    );
};

export default Detail;
