import React from 'react';

import type { IClassNameProps } from '@bem-react/core';

export const ArrowIcon: React.FC<IClassNameProps> = ({ className }) => (
    <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path className={className} d="M0.792893 1.70711C0.402369 1.31658 0.402369 0.683418 0.792893 0.292893C1.18342 -0.0976311 1.81658 -0.0976311 2.20711 0.292893L8.85355 6.93934C9.43934 7.52513 9.43934 8.47487 8.85355 9.06066L2.20711 15.7071C1.81658 16.0976 1.18342 16.0976 0.792893 15.7071C0.402369 15.3166 0.402369 14.6834 0.792893 14.2929L7.08579 8L0.792893 1.70711Z" fill="#9397AD" />
    </svg>
);

export const ReceiptIcon: React.FC<IClassNameProps> = ({ className }) => (
    <svg width="24" height="24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path className={className} fillRule="evenodd" clipRule="evenodd" d="M7.205 3h9.59c1.114 0 1.519.116 1.926.334.407.218.727.538.945.945.218.407.334.811.334 1.926V20a1 1 0 0 1-1.703.712 3.451 3.451 0 0 0-.423-.33A5.15 5.15 0 0 0 15 19.5c-.894 0-1.648.321-2.556.771l-.01.005-.254.128c-.977.49-2.182 1.096-3.68 1.096-1.608 0-3.396-.546-4.331-1.944v-.001A.995.995 0 0 1 4 19V6.205c0-1.115.116-1.519.334-1.926.218-.407.538-.727.945-.945C5.686 3.116 6.09 3 7.205 3zM18 18.162V6.205c0-.427-.019-.694-.049-.849a.353.353 0 0 0-.049-.134.275.275 0 0 0-.124-.124.353.353 0 0 0-.134-.049c-.155-.03-.422-.049-.849-.049h-9.59c-.427 0-.694.019-.849.049a.353.353 0 0 0-.134.049.275.275 0 0 0-.124.124.353.353 0 0 0-.049.134c-.03.155-.049.422-.049.849V18.64c.625.643 1.64.86 2.5.86 1.02 0 1.934-.458 2.826-.906l.23-.115.01-.005c.927-.459 2.042-.974 3.434-.974 1.037 0 2.064.228 3 .662zM9 9a1 1 0 0 1 0-2h4a1 1 0 1 1 0 2H9zm-1 3a1 1 0 0 0 1 1h6a1 1 0 1 0 0-2H9a1 1 0 0 0-1 1zm1 5a1 1 0 1 1 0-2h1a1 1 0 1 1 0 2H9z" fill="#262633" />
    </svg>
);
