import { ReceiptList } from './ReceiptList';

import { TemplateFactory } from '../../../../../../../.storybook/helpers/TemplateFactory';

export default {
    title: 'Component/ReceiptList',
    component: ReceiptList,
    argTypes: {},
    args: {
        currency: 'RUB',
        receipts: [
            {
                url: 'https://ya.ru',
                amount: ['1250.70'],
                timestamp: '2021-03-12T13:45:09+00:00',
                type: 'prepayment',
            },
            {
                url: 'https://ya.ru',
                amount: ['300.00', '125.0000'],
                timestamp: '2021-12-30T20:59:50+00:00',
            },
        ],
    },
};

const template = TemplateFactory(ReceiptList);

export const Default = template({});
