import React, { useState, useEffect } from 'react';

import { useRequest } from '@hooks/useRequest';
import type { IReceipt } from '@src/types';

import { ReceiptList } from './ReceiptList';

interface IReceiptListWrapper {
    purchaseToken?: string;
    currency: string;
    onReceiptEmpty?(): void;
    metrikaParams?: string | object;
    data?: IReceipt[];
}

const ReceiptListWrapper: React.FC<IReceiptListWrapper> = ({
    purchaseToken, currency, onReceiptEmpty, metrikaParams, data,
}) => {
    const [receipts, setReceipts] = useState<IReceipt[] | undefined>(data);
    const request = useRequest();

    useEffect(() => {
        if (!purchaseToken) {
            return;
        }

        request.post('/receipts', { token: purchaseToken })
            .then(({ data: { receipts } }) => {
                if (receipts?.length === 0) {
                    onReceiptEmpty && onReceiptEmpty();
                } else {
                    setReceipts(receipts);
                }
            })
            .catch(() => onReceiptEmpty && onReceiptEmpty());
    }, [request, purchaseToken, onReceiptEmpty]);

    return <ReceiptList currency={currency} receipts={receipts} metrikaParams={metrikaParams} />;
};

export default ReceiptListWrapper;
