import OrderInfo from './index';

import { TemplateFactory } from '../../../../../../.storybook/helpers/TemplateFactory';

export default {
    title: 'Component/OrderInfo',
    component: OrderInfo,
    argTypes: {},
    args: {
        status: 'paid',
        created: '2021-02-02T20:44:40+00:00',
        payments: [
            {
                type: 'afisha_certificate',
                price: 617,
            },
        ],
        details: [
            {
                name: 'Поездка',
                price: 300,
            },
            {
                name: 'Поездка',
                price: 317,
            },
        ],
    },
};

const template = TemplateFactory(OrderInfo);

export const Default = template({});

export const WithCardAndPlus = template({
    payments: [
        {
            method: 'card',
            account: '546938****5639',
            price: 617,
        },
        {
            method: 'yandex_account_withdraw',
            price: 617,
        },
        {
            method: 'new_promocode',
            price: 150,
        },
        {
            method: 'virtual_kinopoisk',
            price: 20,
        },
    ],
});

export const withEdadealCashback = template({
    payments: [
        {
            method: 'card',
            account: '546938****5639',
            price: 617,
        },
        {
            method: 'cashback_edadeal',
            price: 100,
        },
    ],
});

export const GooglePay = template({
    payments: [
        {
            method: 'google_pay',
            price: 617,
        },
    ],
});

export const ApplePay = template({
    payments: [
        {
            method: 'apple_pay',
            price: 617,
        },
    ],
});

export const WithButtons = template({
    serviceUrl: 'https://ya.ru',
    helpUrl: 'https://help.yandex.ru',
});

export const AdvanceStatus = template({
    status: 'advance',
});

export const UnknownPaymentCard = template({
    payments: [
        {
            method: 'card',
            account: '',
            price: 617,
        },
    ],
});

export const PushView = template({
    payments: [
        {
            method: 'card',
            account: '546938****5639',
            price: 1200,
        },
    ],
    details: [],
    isPushView: true,
});
