import React from 'react';
import { useHistory, useLocation } from 'react-router';

import DetailPage from '@components/DetailPage';
import useRoutes from '@hooks/useRoutes';

import OrderDetails from './OrderDetails';

const OrderDetailsRoute: React.FC = () => {
    const routes = useRoutes();
    const history = useHistory();
    const { state } = useLocation();

    const handleClose = React.useCallback(() => {
        const { state, ...to } = history.location;

        history.replace(to);
    }, [history]);

    if (!state || !state.props) {
        history.replace(routes.main());

        return null;
    }

    return (
        <DetailPage onClose={handleClose}>
            <OrderDetails data={state.props} />
        </DetailPage>
    );
};

export default OrderDetailsRoute;
