import OrderHeader from './index';

import 'yandex-font/build/browser.css';
import { TemplateFactory } from '../../../../../../.storybook/helpers/TemplateFactory';

export default {
    title: 'Component/OrderHeader',
    component: OrderHeader,
    argTypes: {},
    args: {
        imageLink: '',
        iconUrl: 'https://yastatic.net/s3/chat-static/favicons/favicon-180.png',
        name: 'Яндекс.Такси',
        details: 'Поездка',
        price: -517,
        currency: 'RUB',
    },
};

const template = TemplateFactory(OrderHeader);

export const Default = template({});

export const Plus = template({
    price: undefined,
    name: 'Баллы плюса',
    iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
    splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
    details: 'Яндекс.Такси',
    plus: 600,
});

export const PlusDeducting = template({
    price: undefined,
    plus: -63,
});

export const Cancelled = template({
    status: 'cancelled',
});

export const Refunded = template({
    status: 'refunded',
});

export const Advance = template({
    status: 'advance',
});

export const FamilyPayment = template({
    initiatorAvatar: '//avatars.mdst.yandex.net/get-yapic/1824/SpilA8dV7VClkcTgd3Fuwslx7M-1/islands-retina-middle',
    initiatorName: 'Инокентий',
});

export const PushViewRu = template({
    iconUrl: null,
    name: '',
    details: '',
    isPushView: true,
    lang: 'ru',
});

export const PushViewEn = template({
    iconUrl: null,
    name: '',
    details: '',
    isPushView: true,
});
