import React, { useEffect, useRef } from 'react';

import { i18nCommon } from '@client/translations/common';
import Button from '@components/Button';
import { canUseDom } from '@use-platform/react/libs/dom-utils';

import styles from './index.module.css';

type Props = {
    onHit: () => void;
};

const WITHOUT_INTERSECTION = () => !('IntersectionObserver' in window);

const MainScreenAnchor = ({ onHit }: Props) => {
    const ref = useRef<HTMLDivElement | null>(null);

    useEffect(() => {
        if (!ref.current || WITHOUT_INTERSECTION()) {
            return;
        }

        const observer = new IntersectionObserver(([entry]) => {
            if (entry.isIntersecting) {
                onHit();
            }
        });

        observer.observe(ref.current);

        return () => {
            observer.disconnect();
        };
    }, [onHit]);

    if (canUseDom && WITHOUT_INTERSECTION()) {
        return (
            <div className={styles.loadButton__container}>
                <div className={styles.loadButton}>
                    <Button onClick={onHit} view="default" size="m">
                        {i18nCommon('download_more')}
                    </Button>
                </div>
            </div>
        );
    }

    return <div ref={ref} />;
};

export default MainScreenAnchor;
