import React, { useCallback } from 'react';

import { Tag } from '@components/Tag/Tag';
import { useDispatch } from '@hooks/redux';
import useMetrika from '@hooks/useMetrika';
import { useServiceName } from '@hooks/useServiceName';
import type { IService } from '@src/types';

import styles from './index.module.css';

interface Props {
    item: IService;
    active: boolean;
}

const Item: React.FC<Props> = ({ item, active }) => {
    const dispatch = useDispatch();
    const onChangeAlias = useCallback((alias?: string) => dispatch({ type: 'CHANGE_ALIAS', payload: alias }), [dispatch]);

    const metrika = useMetrika();

    const handleClick = React.useCallback(() => {
        metrika.params({
            [active ? 'clear_filter' : 'click_filter']: item.alias, // Фолбек на старый дашборд (потом удалить)
            [active ? 'click_clear_filter' : `click_filter_${item.alias}`]: true,
        });

        onChangeAlias(active ? undefined : item.alias);
    }, [metrika, item.alias, active, onChangeAlias]);
    const serviceName = useServiceName(item.name, item.i18nKeyName);

    return (
        <Tag
            className={styles.item}
            onClick={handleClick}
            iconUrl={item.iconUrl}
            text={serviceName}
            active={active} />
    );
};

export default Item;
