import React from 'react';

import { HorizontalScroll } from '@yandex-int/tap-components/HorizontalScroll';
import { Rect } from '@yandex-int/tap-components/Skeleton';

import styles from './index.module.css';

const FilterItemSkeleton: React.FC = () => {
    return (
        <div className={styles.item_skeleton}>
            <Rect width="90px" height="36px" borderRadius="100px" />
        </div>
    );
};

const FilterListSkeleton: React.FC = () => {
    return (
        <HorizontalScroll className={styles.scroll} contentClassName={styles.scroll__content}>
            <FilterItemSkeleton />
            <FilterItemSkeleton />
            <FilterItemSkeleton />
            <FilterItemSkeleton />
            <FilterItemSkeleton />
        </HorizontalScroll>
    );
};

export default FilterListSkeleton;
