import React, { useCallback } from 'react';

import { HorizontalScroll } from '@yandex-int/tap-components/HorizontalScroll';

import { setFamilyFilter } from '@client/redux/orders';
import { i18nCommon } from '@client/translations/common';
import { Tag, ITagProps } from '@components/Tag/Tag';
import { useDispatch, useSelector } from '@hooks/redux';
import useConstants from '@hooks/useConstants';
import { usePassportAvatar } from '@hooks/usePassportAvatar';
import type { IService } from '@src/types';

import styles from './index.module.css';
import Item from './Item';

interface Props {
    data: IService[];
    active?: Nullable<string>;
}

const UserTag: React.FC<ITagProps> = (props) => {
    const avatarUrl = usePassportAvatar(props.iconUrl);

    return <Tag className={styles.item} {...props} iconUrl={avatarUrl} />;
};

const FilterList: React.FC<Props> = ({ active, data }) => {
    const dispatch = useDispatch();
    const { familyUsers, authInfo } = useConstants();
    const familyUsersArray = (familyUsers && Object.values(familyUsers)) || [];
    const familyFilter = useSelector((state) => state.orders.familyFilter);

    const onClickFamilyFilter = useCallback((uid?: string) => () => {
        dispatch(setFamilyFilter(uid !== familyFilter ? uid : undefined));
    }, [dispatch, familyFilter]);

    if (data.length < 2) {
        return null;
    }

    return (
        <HorizontalScroll className={styles.scroll} contentClassName={styles.scroll__content}>
            {familyUsersArray.length > 0 && (
                <>
                    <UserTag
                        iconUrl={authInfo?.user.avatarId}
                        text={i18nCommon('i')}
                        onClick={onClickFamilyFilter(authInfo?.user.uid)}
                        active={familyFilter === authInfo?.user.uid} />
                    {familyUsersArray.map(({ name, avatar, uid }) => {
                        return (
                            <UserTag
                                key={uid}
                                iconUrl={avatar}
                                text={name}
                                onClick={onClickFamilyFilter(uid)}
                                active={familyFilter === uid} />
                        );
                    })}
                    <div className={styles.divider}>•</div>
                </>
            )}

            {data.map((item, i) => (
                <Item key={item.alias + String(i)} active={item.alias === active} item={item} />
            ))}
        </HorizontalScroll>
    );
};

export default FilterList;
