import React from 'react';

import { i18nCommon } from '@client/translations/common';
import CardSkeleton from '@components/Card/Skeleton';
import ListDivider from '@components/ListDivider';
import ListOrdersItem from '@components/ListOrders/ListOrdersItem';

const OrdersListSkeleton: React.FC = () => {
    return (
        <>
            <ListOrdersItem>
                <ListDivider text={i18nCommon('loading_list')} />
            </ListOrdersItem>
            <ListOrdersItem>
                <CardSkeleton />
            </ListOrdersItem>
            <ListOrdersItem>
                <CardSkeleton />
            </ListOrdersItem>
            <ListOrdersItem>
                <CardSkeleton />
            </ListOrdersItem>
        </>
    );
};

export default OrdersListSkeleton;
