import i18nFactory from '@i18n';
import * as keyset from '@i18n/MainScreen.i18n';
import qs from 'query-string';

import { i18nServices, ServiceKeyType } from '@client/translations/services';
import { IStubProps } from '@components/Stub';
import { IService } from '@src/types';

export type QueryParams = {
    alias: string | null;
};

const i18n = i18nFactory(keyset);

export const getQueryParams = (search?: string): QueryParams => {
    const allQueryParams = !search ? {} : qs.parse(search);
    const alias = typeof allQueryParams.alias === 'string' ? allQueryParams.alias : null;

    return {
        alias,
    };
};

export const getStubProps = (alias?: string, services?: IService[]): IStubProps => {
    if (!alias) {
        return {
            title: i18n('Платежей пока нет'),
            description: i18n('Радуйте себя покупками, получайте баллы Плюса, а мы покажем это в истории платежей'),
            withBackButton: false,
        };
    }

    const titles: Record<string, string> = {
        plus: i18n('Платежей и кешбэка Плюса пока нет'),
        receipts: i18n('Чеков пока нет'),
    };

    const descriptions: Record<string, string> = {
        plus: i18n('Платежей и кешбэка Плюса пока нет'),
        receipts: i18n('Радуйте себя покупками, и новые платежи отобразятся в этом разделе.'),
    };

    return {
        title: titles[alias] || i18n('Таких платежей пока нет'),
        description: descriptions[alias] || `Похоже, вы ещё не покупали на сервисе ${i18nServices(alias as ServiceKeyType)}`,
        withBackButton: alias !== 'receipts',
        buttonText: i18n('Перейти на сервис'),
        serviceUrl: services?.find((item) => item.alias === alias)?.url,
    };
};
