import React, { memo, useRef, useEffect } from 'react';
import { useLocation } from 'react-router';

import Block from '@components/Block';
import useConstants from '@hooks/useConstants';

import Top from './Header';
import styles from './index.module.css';
import OrdersList from './List';
import { getQueryParams } from './List/helpers';

const OrdersHistory = () => {
    const listRef = useRef<HTMLDivElement>(null);
    const { search } = useLocation();
    const { alias } = getQueryParams(search);
    const { flags: { hideReceiptBanner }, platform } = useConstants();

    useEffect(() => {
        /*
            На тачах, имея alias пропускаем баннер электрочеков и скролим к списку
        */
        if (alias && !hideReceiptBanner && platform.isTouch && listRef.current) {
            const { x, y } = listRef.current.getBoundingClientRect();

            window.scrollTo(x, y);
        }
    }, []);

    return (
        <Block>
            <div className={styles.top}>
                <Top />
            </div>
            <div className={styles.content} ref={listRef}>
                <OrdersList />
            </div>
        </Block>
    );
};

export default memo(OrdersHistory);
