import i18nFactory from '@i18n';
import * as keyset from '@i18n/MainScreen.i18n';
import React, { memo } from 'react';
import { Link } from 'react-router-dom';

import { classNames } from '@yandex-int/tap-components/helpers';

import Image from '@components/Image';

import styles from './index.module.css';

const i18n = i18nFactory(keyset);

export interface PayServicesListItemProps {
    iconUrl: string;
    notificationsCount?: number;
    disabled?: boolean;
    path?: string;
    name: string;
}

const PayServicesListItem = ({
    iconUrl,
    notificationsCount,
    path,
    name,
    disabled = false,
}: PayServicesListItemProps) => {
    if (disabled) {
        return (
            <div className={styles['service-card']}>
                <div className={styles['icon-container']}>
                    <Image alt={name} src={iconUrl} />
                </div>
                <div className={classNames(styles.info, styles.disabled)}>
                    <span className={styles.soon}>{i18n('Скоро').toLocaleLowerCase()}</span>
                    <span className={styles.name}>{name}</span>
                </div>
            </div>
        );
    }

    return (
        <Link to={path} className={styles['service-card']}>
            <div className={styles['icon-container']}>
                <Image alt={name} src={iconUrl} />
            </div>
            {Boolean(notificationsCount) && <div className={styles.notifications}>{notificationsCount}</div>}
            <div className={styles.info}>
                <span className={styles.name}>{name}</span>
            </div>
        </Link>
    );
};

export default memo(PayServicesListItem);
