import { IPayService } from '@src/types';

import 'yandex-font/build/browser.css';
import PayServicesList from './index';

import { TemplateFactory } from '../../../../../../.storybook/helpers/TemplateFactory';

const payServicesList: (IPayService & { notificationsCount?: number; })[] = [
    {
        name: 'Штрафы ГИБДД',
        iconUrl: 'https://avatars.mds.yandex.net/get-bunker/118781/fb147f596589a29c97342c7fd29f1cc6b81674ad/svg',
        path: '#',
        notificationsCount: 3,
    },
    {
        name: 'ЖКХ',
        iconUrl: 'https://avatars.mds.yandex.net/get-bunker/135516/db5574fdc5eea54cefc786eff53267e0a7dbf1c7/svg',
        path: '#',
    },
    {
        name: 'ФНС',
        iconUrl: 'https://avatars.mds.yandex.net/get-bunker/56833/46b3b118c42df3363746292963259ebb54c57da3/svg',
        disabled: true,
    },
    {
        name: 'ФССП',
        iconUrl: 'https://avatars.mds.yandex.net/get-bunker/128809/6af41da8c09762a4b690695391387f49bd688c12/svg',
        disabled: true,
    },
];

export default {
    title: 'Component/PayServicesList',
    component: PayServicesList,
    argTypes: {},
    args: {
        services: payServicesList,
    },
};

const template = TemplateFactory(PayServicesList);

export const Default = template({});
