import React, { memo, useMemo } from 'react';

import { HorizontalScroll } from '@yandex-int/tap-components/HorizontalScroll';

import type { IPayService } from '@src/types';

import styles from './index.module.css';
import PayServicesListItem from './Item';
interface PayServicesListProps {
    services?: IPayService[];
}

const PayServicesList = ({ services = [] }: PayServicesListProps) => {
    const widgets = useMemo(() => {
        return services ?
            services.map((service) => <PayServicesListItem
                key={service.name} {...service}
            />) :
            null;
    }, [services]);

    return (
        <HorizontalScroll className={styles['services-list']}>
            {widgets}
        </HorizontalScroll>
    );
};

export default memo(PayServicesList);
