import React, { useCallback, useMemo, useRef } from 'react';
import { useHistory, useLocation } from 'react-router';

import { usePreventScroll } from '@yandex-lego/components/usePreventScroll';

import { toogleHashRoute } from '@client/helpers/history';
import { CashbackShortcut } from '@components/CashbackShortcut';
import Page from '@components/Page';
import { PlusShortcut } from '@components/PlusShortcut';
import { ReceiptsPopup } from '@components/ReceiptsPopup';
import useConstants from '@hooks/useConstants';
import useMetrika from '@hooks/useMetrika';

import styles from './index.module.css';
import OrderListBlock from './OrdersHistory';
import PayServicesBlock from './PayServices';
import { FamilyShortcut } from '@components/FamilyShortcut';
import { PayShortcut } from '@components/PayShortcut';
import { Carousel, CarouselItem } from '@yandex-id/components';

const MainScreen: React.FC = () => {
    const { payServicesEnabled, payServices, flags: { fnsEnabled }, fnsData, tld } = useConstants();
    const history = useHistory();
    const { hash } = useLocation();
    const metrika = useMetrika();
    const containerRef = useRef<HTMLDivElement>(null);

    const popupIsOpen = useMemo(() => hash === '#receipts-popup', [hash]);

    const showPayServices = useMemo(() =>
        (payServicesEnabled && Boolean(payServices) && payServices.length), [payServicesEnabled, payServices]);

    const onClosePopup = useCallback(() => {
        toogleHashRoute(history, '#receipts-popup');
    }, [history]);

    const onSuccess = useCallback(() => {
        metrika.params({ receipts_bound_success: true });
        onClosePopup();

        window.location.reload();
    }, [onClosePopup, metrika]);

    usePreventScroll({ enabled: popupIsOpen, containerRef });

    return (
        <Page containerRef={containerRef}>
            {tld === 'ru' && (
                <Carousel className={styles.shorcuts}>
                    <CarouselItem className={styles.shortcut}>
                        <PlusShortcut />
                    </CarouselItem>
                    <CarouselItem className={styles.shortcut}>
                        <CashbackShortcut />
                    </CarouselItem>
                    <CarouselItem className={styles.shortcut}>
                        <FamilyShortcut />
                    </CarouselItem>
                    <CarouselItem className={styles.shortcut}>
                        <PayShortcut />
                    </CarouselItem>
                </Carousel>
            )}
            {showPayServices && <PayServicesBlock />}
            <OrderListBlock />
            {fnsEnabled && !fnsData?.isBind && (
                <ReceiptsPopup
                    visible={popupIsOpen}
                    onSuccess={onSuccess}
                    onClose={onClosePopup} />
            )}
        </Page>
    );
};

export default MainScreen;
