import React, { useEffect } from 'react';

import { useSelector } from '@hooks/redux';
import { useWebAm } from '@hooks/useWebAm';

import OrderDetails from '../MainScreen/OrdersDetails/OrderDetails';

export const PaymentScreen: React.FC = () => {
    const order = useSelector((state) => state.orders.order);
    const webAmApi = useWebAm();

    useEffect(() => {
        webAmApi?.setPopupSize({ mode: 'fullscreen' });
        webAmApi?.ready();
    }, []);

    if (!order) {
        return <div>Ошибка</div>;
    }

    return (
        <OrderDetails data={order} />
    );
};
