import i18nFactory from '@i18n';
import * as keyset from '@i18n/Common.i18n';

import { I18nOptions } from '@yandex-int/i18n';
const i18n = i18nFactory(keyset);

const commonKeyset = {
    test: () => i18n('Назад'),
    adding_account: () => i18n('Пополнение счёта'),
    all: () => i18n('Всё'),
    backwards: () => i18n('Назад'),
    buy: () => i18n('Покупка'),
    cash_voucher: () => i18n('Чек'),
    cashback_plus: () => i18n('Кешбэк баллами Плюса'),
    companyRating: () => i18n('Рейтинг компании'),
    contribution: () => i18n('Вклад в фонд'),
    delivery: () => i18n('Доставка'),
    download_more: () => i18n('Загрузить еще'),
    footer_feedback: () => i18n('Обратная связь'),
    footer_help: () => i18n('Справка'),
    free: () => i18n('Бесплатно'),
    gratuity: () => i18n('Чаевые'),
    help: () => i18n('Помощь'),
    support: () => i18n('Поддержка'),
    loading_list: () => i18n('Секунду, сейчас загрузим...'),
    ok: () => i18n('Хорошо'),
    overall: () => i18n('Всего'),
    paymentAdvance: () => i18n('авансовый'),
    paymentByCard: () => i18n('Оплата картой'),
    paymentCanceled: () => i18n('Отменён'),
    paymentCreated: () => i18n('Создан'),
    paymentPartiallyRefunded: () => i18n('Частичный возврат'),
    paymentRefunded: () => i18n('Возврат'),
    payments_details: () => i18n('Детали платежа'),
    plus_service_name: () => i18n('Баллы Плюса'),
    promocode: () => i18n('Промокод'),
    refill: () => i18n('Заправка'),
    reload: () => i18n('Перезагрузить'),
    reloadPage: () => i18n('Перезагрузить страницу'),
    repeat: () => i18n('Повторить'),
    ride: () => i18n('Поездка'),
    subscription: () => i18n('Подписка'),
    to_service: () => i18n('На сервис'),
    today: () => i18n('Сегодня'),
    update: () => i18n('Обновить'),
    yandex: () => i18n('Яндекс'),
    yesterday: () => i18n('Вчера'),
    points: (options?: I18nOptions) => i18n('балл', options),
    tikets: (options?: I18nOptions) => i18n('билет', options),
    goods: (options?: I18nOptions) => i18n('товар', options),
    penalties: (options?: I18nOptions) => i18n('штраф', options),
    close: () => i18n('Закрыть'),
    my_purchase: () => i18n('Моя покупка'),
    yandexpayBuy: () => i18n('Покупка с Yandex Pay'),
    connect: () => i18n('Подключить'),
    i: () => i18n('Я'),
};

export const i18nCommon = (key: keyof typeof commonKeyset, options?: I18nOptions) => {
    return commonKeyset[key](options);
};
