import i18nFactory from '@i18n';
import * as keyset from '@i18n/Payments.i18n';

import { i18nCommon } from './common';

const i18n = i18nFactory(keyset);

const paymentsKeyset = {
    Mir: () => i18n('МИР'),
    AmericanExpress: () => i18n('American Express'),
    Visa: () => i18n('VISA'),
    MasterCard: () => i18n('Master Card'),
    UnionPay: () => i18n('Union Pay'),
    paying: () => i18n('Успешная оплата'),
    card: () => i18n('Оплата картой'),
    yamoney_wallet: () => i18n('Оплата ЮMoney'),
    cash: () => i18n('Оплата наличными'),
    new_promocode: () => i18n('Оплата промокодом'),
    spasibo: () => i18n('Оплата бонусами от СберБанка'),
    yandex_account_withdraw: () => i18nCommon('plus_service_name'),
    yandex_account_topup: () => i18nCommon('plus_service_name'),
    afisha_certificate: () => i18n('Оплата промокодом Афишы'),
    google_pay: () => i18n('Оплата через Google Pay'),
    apple_pay: () => i18n('Оплата через Apple Pay'),
    virtual_kinopoisk: () => i18n('Скидка'),
    sbp_qr: () => i18n('Оплата СБП'),
    cashback_edadeal: () => i18n('Кешбэк Едадила'),
};

export type PaymentsKeyType = keyof typeof paymentsKeyset;

export const i18nPayments = (key: PaymentsKeyType) => {
    return paymentsKeyset[key]() || key;
};
