import i18nFactory from '@i18n';
import * as keyset from '@i18n/Services.i18n';

import { i18nCommon } from './common';

const i18n = i18nFactory(keyset);

const servicesKeyset = {
    market: () => i18n('Маркет'),
    afisha: () => i18n('Афиша'),
    drive: () => i18n('Драйв'),
    lavka: () => i18n('Лавка'),
    eats: () => i18n('Еда'),
    taxi: () => i18n('Go'),
    pay: () => i18n('Yandex Pay'),
    travel: () => i18n('Путешествия'),
    uslugi: () => i18n('Услуги'),
    refill: () => i18n('Заправки'),
    kinopoisk: () => i18n('Кинопоиск'),
    invest: () => i18n('Инвестиции'),
    help_nearby: () => i18n('Помощь рядом'),
    music: () => i18n('Музыка'),
    plus: () => i18n('Плюс'),
    plus_points: () => i18n('Баллы Плюса'),
    plus_subscribe: () => i18n('Подписка Плюса'),
    plus_360: () => i18n('Подписка Яндекс 360'),
    praktikum: () => i18n('Практикум'),
    realty: () => i18n('Недвижимость'),
    surveys: () => i18n('Вгляд'),
    health: () => i18n('Здоровье'),
    toloka: () => i18n('Толока'),
    business: () => i18n('Бизнес'),
    bnpl: () => i18n('Сплит'),
    receipts: () => i18n('Мои чеки'),
    games: () => i18n('Игры'),
    tips: () => i18n('Чаевые'),
    yandex_account: () => i18n('Счёт в Яндексе'),
    unknown: () => i18nCommon('yandex'),
};

export type ServiceKeyType = keyof typeof servicesKeyset;

export const i18nServices = (key: ServiceKeyType) => {
    return servicesKeyset[key] && servicesKeyset[key]();
};
