export const cast = <S>(s: S): S => s;
export const warnImpossible = (value: never, message?: string) =>
    console.error('impossible value: ' + message || String(value)); // eslint-disable-line
export const isFunction = (value: unknown) => typeof value === 'function';
export const arrayOf = <T extends keyof ANY>(o: Record<T, unknown>) =>
    Object.keys(o).sort((a, b) => {
        if (o[a] > o[b]) {
            return 1;
        } else if (o[a] < o[b]) {
            return -1;
        }

        return 0;
    });
export const getOrderServiceType = (serviceId: number) => (serviceId === 1 ? 'ya-turbo' : null);

export function isStrictDefined<T>(value: T | undefined | null): value is T {
    return value !== null && typeof value !== 'undefined';
}
