import type Ya from '@yandex-int/error-counter/dist/logger.js';

import type { Constants } from '../../types';

const rumNotInit = () => !window?.Ya?.Rum;

type EnviromentHashNameType = {
    [key in Constants['env']]?: Ya.Rum.LogEnvironment;
}

export const logErrorInit = (yandexuid?: string, platform?: 'touch' | 'desktop', enviroment: Constants['env'] = 'testing') => {
    if (!window || process.env.NODE_ENV === 'development') {
        return;
    }

    require('@yandex-int/rum-counter/dist/inline/interface.js');
    require('@yandex-int/rum-counter/dist/inline/longtask.js');
    require('@yandex-int/rum-counter/dist/bundle/send.js');
    require('@yandex-int/error-counter/dist/interfaceOverRum.js');
    require('@yandex-int/error-counter/dist/implementation.js');
    require('@yandex-int/error-counter/dist/filters.js');
    require('@yandex-int/error-counter/dist/logError.js');
    require('@yandex-int/error-counter/dist/logAjaxError.js');
    require('@yandex-int/error-counter/dist/logger.js');

    const project = 'passport-order-history';
    const reqid = `${Date.now()}.${Math.random()}`;

    const enviromentNameHash: EnviromentHashNameType = {
        rc: 'prestable',
        prod: 'production',
    };

    const env = enviromentNameHash[enviroment] || 'testing';

    const config: Ya.Rum.LogErrorInitSettings = {
        env,
        preventError: false,
        unhandledRejection: true,
        reqid,
        limits: {
            client: 1000,
            uncaught: 100,
            script: 100,
            external: 100,
        },
        project,
        platform,
        yandexuid,
    };

    window.Ya.Rum.init({
        beacon: true,
        clck: 'https://yandex.ru/clck/click',
        reqid,
    }, {
        rum_id: `ru.ohio.${platform}.index`,
        region: 213, // в данный момент регион для скоростных метрик не интересен
        '-platform': platform,
        '-page': 'index',
        '-project': project,
        '-env': env,
    });

    // должен выполняться после(!) Ya.Rum.init()
    require('@yandex-int/rum-counter/dist/bundle/implementation.js');

    window.Ya.Rum.initErrors(config);
};

export const logError = (originalError: Ya.Rum.LoggableError, logFields: Ya.Rum.LogErrorOptions = {}) => {
    if (rumNotInit()) {
        return;
    }

    window.Ya.Rum.logError(
        {
            level: window.Ya.Rum.ERROR_LEVEL.ERROR,
            ...logFields,
        },
        originalError || new Error('Empty error!'),
    );
};
