import React from 'react';
import { StaticRouter } from 'react-router-dom';

import { setI18nLang } from '@yandex-int/i18n';

import App from '@client/App';
import type { ServerRenderProps } from '@src/types';

export const Root = ({ req, context, ...rest }: ServerRenderProps) => () => {
    setI18nLang(rest.constants.lang);

    return (
        <StaticRouter context={context} location={req.originalUrl.replace('index.html', '')}>
            <App {...rest} />
        </StaticRouter>
    );
};
