import development from './development';
import local from './local';
import production from './production';
import rc from './rc';
import testing from './testing';
import type { Config } from './types';

type ConfigName = 'development' | 'testing' | 'production' | 'local' | 'rc';

const configs: Record<ConfigName, Config> = {
    development,
    testing,
    rc,
    production,
    local,
};
const names = Object.keys(configs);
const configEnv = process.env.NODE_CONFIG_ENV || process.env.NODE_ENV;
const config: Config = configs[configEnv && names.includes(configEnv) ? configEnv : 'production'];

export default config;
