import rc from './rc';
import type { Config } from './types';

const edadealHost = 'https://desktop.checks.edadeal.yandex.ru';

const config: Config & typeof rc = {
    ...rc,
    environment: 'prod',
    backend: {
        ...rc.backend,
        url: 'https://ohio-backend.so.yandex.net',
    },
    blackbox: {
        ...rc.blackbox,
        url: 'https://blackbox.yandex.net',
    },
    edadeal: {
        hosts: [edadealHost],
    },
    csp: {
        ...rc.csp,
        'report-uri':
            'https://csp.yandex.net/csp?from=order-history&project=passport-order-history',
        'frame-src': [...rc.csp['frame-src'], edadealHost],
    },
    bunker: {
        ...rc.bunker,
        project: '/passport-order-history',
    },

    // logger: {
    //     file: {
    //         rotate: true,
    //         level: 'info',
    //         path: '/logs/',
    //     },
    //     tsv: {
    //         rotate: true,
    //         level: 'warn',
    //         path: '/logs/',
    //     },
    // }, TODO
};

export default config;
