import common from './common';
import type { Config } from './types';

const config: Config & typeof common = {
    ...common,
    environment: 'rc',
    metrika: {
        id: '784657',
    },
    backend: {
        ...common.backend,
        url: 'https://ohio-backend-rc.so.yandex.net',
    },
    billsBackend: {
        ...common.billsBackend,
        url: 'https://bills.pay.yandex.ru',
    },
    payments: {
        ...common.payments,
        url: 'https://payments.mail.yandex.net',
    },
    blackbox: {
        ...common.blackbox,
        url: 'https://blackbox-rc.yandex.net',
    },
    trust: {
        ...common.trust,
        url: 'https://api.trust.yandex.net',
    },
    bunker: {
        ...common.bunker,
        url: 'http://bunker-api.yandex.net/v1',
    },
    passport: {
        ...common.passport,
        host: 'passport.yandex.{tld}',
    },
    search: {
        url: 'http://new-msearch-proxy.mail.yandex.net:8051',
        timeout: 4500,
    },
    csp: {
        ...common.csp,
        'img-src': [...common.csp['img-src'], 'https://pay.yandex.ru'],
        'connect-src': [...common.csp['connect-src'], 'https://pay.yandex.ru'],
        'frame-src': [...common.csp['frame-src'], 'https://pay.yandex.ru'],
        'script-src': [...common.csp['script-src'], 'https://pay.yandex.ru'],
    },
    yandexPay: {
        scriptSrc: 'https://pay.yandex.ru/sdk/v1/pay.js',
        merchantId: '72360794-5752-4570-aad8-543ed3d22834',
        merchantName: 'passport-bills',
        gateway: 'mobimoney',
        gatewayId: 'oplatagosuslug',
        env: 'PRODUCTION',
    },
};

export default config;
