import type { ExpressCSPParams } from 'express-csp-header';

// type Logger = {
//     pretty?: boolean;
//     level: 'debug' | 'info' | 'warn' | 'error';
// };

type DataSourceInfo = {
    url: string;
    timeout: number;
};

type ExpressCspDirectives = ExpressCSPParams['directives'];
type GetCSPListDirectives<T> = T extends Partial<Record<string, string[]>> ? T : never;
type GetCSPStringDirectives<T> = T extends Partial<Record<string, string>> ? T : never;
type GetCSPBooleanDirectives<T> = T extends Partial<Record<string, boolean>> ? T : never;

export type CSPDirectives = GetCSPListDirectives<ExpressCspDirectives> &
    GetCSPStringDirectives<ExpressCspDirectives> &
    GetCSPBooleanDirectives<ExpressCspDirectives>;

export type Config = {
    local: boolean;
    baseUrl: string;
    version: string;
    hs: DataSourceInfo;
    backend: DataSourceInfo;
    billsBackend: DataSourceInfo;
    search: DataSourceInfo;
    payments: DataSourceInfo;
    environment: 'dev' | 'prod' | 'stress' | 'testing' | 'rc';
    csp: CSPDirectives;
    chat?: {
        env: 'development';
    };
    paths: {
        public: string;
        assets: string;
        versionized: string;
        clientBuild: string;
        serverBuild: string;
        loadableStats: string;
    };
    metrika: {
        id: string;
    };
    yandex: {
        host: string;
    };
    passport: {
        host: string;
    };
    edadeal: {
        hosts: string[];
    };
    images: {
        avatarHost: string;
    };
    uatraits: {
        type: 'http' | 'library';
    };
    blackbox: DataSourceInfo;
    trust: DataSourceInfo;
    csrf: {
        salt: string;
    };
    bunker: {
        url: string;
        project: string;
    };
    yandexPay: {
        scriptSrc: string;
        merchantId: string;
        merchantName: string;
        gateway: string;
        gatewayId: string;
        env: 'TESTING' | 'PRODUCTION';
    };
    bills: {
        maxSelected: number;
    };
    // logger: { console?: Logger } & Partial<
    //     Record<
    //         'file' | 'tsv',
    //         Logger & {
    //             path?: string;
    //             rotate?: boolean;
    //         }
    //     >
    // >; TODO
};
