import { ChunkExtractor } from '@loadable/server';

import config from './config';

export const base64Encode = (str: string) => Buffer.from(str).toString('base64');
export const base64Decode = (str: string) => Buffer.from(str, 'base64').toString('utf-8');

export const createExtractor = (options: { entrypoints?: string[]; namespace?: string; }) =>
    new ChunkExtractor({
        publicPath: config.paths.assets,
        statsFile: config.paths.loadableStats,
        entrypoints: options.entrypoints,
        namespace: options.namespace,
    });
