import * as fs from 'fs';
import * as path from 'path';

import * as uuid from 'uuid';

export function makeDump<T, D>(pathToFolder: string, testData: T, appContext: AppContext, callback: () => D) {
    const uid = uuid.v4();

    return updateDump(path.resolve(pathToFolder, `${uid}.dump.ts`), testData, appContext, callback);
}

export function updateDump<T, D>(pathToFile: string, testData: T, appContext: AppContext, callback: () => D) {
    const writeStream = fs.createWriteStream(path.resolve(pathToFile));

    writeStream.write(
        `export const context = ${JSON.stringify({
            services: appContext.services,
            discounts: Array.from(appContext.discounts),
            servicesOrder: appContext.servicesOrder,
            plusServiceData: appContext.plusServiceData,
        }, null, 4)};\n\r`,
    );

    writeStream.write(`export const test = ${JSON.stringify(testData, null, 4)};\n\r`);

    const result = callback();

    writeStream.write(`export const expectation = ${JSON.stringify(result, null, 4)};`);

    writeStream.close();

    return result;
}
