export function saftyParseFloat(value: string, defaultValue: number = 0): number {
    try {
        const result = parseFloat(value);

        if (typeof result === 'undefined' || isNaN(result)) {
            return defaultValue;
        }

        return result;
    } catch {
        return defaultValue;
    }
}
