import config from '../config';

// eslint-disable-next-line @typescript-eslint/no-var-requires
const pino = require('pino');
// eslint-disable-next-line @typescript-eslint/no-var-requires
const pinoDeploy = require('pino-deploy')();

const dev = config.environment === 'dev';

!dev && pinoDeploy.pipe(process.stdout);

export default pino(
    {
        level: process.env.LOG_LEVEL || 'info',
        prettyPrint: !dev ? false : { colorize: true },
    },
    !dev ? pinoDeploy : undefined,
);
