interface BlackboxFamilyUser {
    uid: string;
}

interface BlackboxFamily {
    admin_uid: string;
    users: BlackboxFamilyUser[];
}

export interface BlackboxFamilyInfo {
    family: Record<string, BlackboxFamily>;
}

interface BlackboxUserInfo {
    id: string;
    login: string;
    attributes: {
        '27': string;
    } & Record<string, unknown>;
    display_name: {
        name: string;
        avatar: {
            default: string;
            empty: boolean;
        };
    };
}

export interface BlackboxUserInfoData {
    users: BlackboxUserInfo[];
}

export interface UserInfo {
    name: string;
    avatar?: string;
    uid: string;
}
