export const context = {
    services: {
        refill: {
            alias: 'refill',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/3b095c224131ca8faa87bfec5099a480c1fda911/svg',
            ids: {},
            name: 'Заправки',
            i18nKeyName: 'refill',
            url: 'https://zapravki.yandex.ru/',
            help: 'https://yandex.ru/chat#/user/3d8f0007-f610-914e-45f7-3eddaf3cc441',
        },
        plus_360: {
            alias: 'plus_360',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/49ef2ec62be2f58b5f765b12cdfd9a04dd826e0e/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e4a8e3d3f8810a4cbebed1fc7f8952bd5df8d870/orig',
            ids: {},
            name: 'Подписка Яндекс 360',
            i18nKeyName: 'plus_360',
            url: 'https://mail360.yandex.ru',
            help: 'https://yandex.ru/support/mail/yandex-360.html',
        },
        praktikum: {
            alias: 'praktikum',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/2029eb942ed84255579609bdd006f29bd6710d75/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/118781/57dd72c90f5871728407efd8c1e14495fee46761/orig',
            ids: {},
            name: 'Практикум',
            i18nKeyName: 'praktikum',
            url: 'https://practicum.yandex.ru/',
            help: 'https://yandex.ru/support/praktikum/feedback.html',
        },
        travel: {
            alias: 'travel',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/61205/e18dfaf6ae7e62e4a3be97bfd77e57ef33541404/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e1b838d55b6d1640a31323774f4f5a77a349766e/orig',
            ids: {},
            name: 'Путешествия',
            i18nKeyName: 'travel',
            url: 'https://travel.yandex.ru/hotels/',
            help: 'https://yandex.ru/support/travel/troubleshooting.html',
        },
        market: {
            alias: 'market',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/ae1b6a5e3bd6905ee694fedc593e6ac497fee0e2/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/35e70a852d59a7bd9c229bbf7d943f9155e65948/orig',
            ids: {},
            name: 'Маркет',
            i18nKeyName: 'market',
            url: 'https://pokupki.market.yandex.ru/my/orders',
        },
        afisha: {
            alias: 'afisha',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/128809/d4f71a94e2abd037b9e3862eca8824f6188ce7a9/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/ea8ff7736616b4920852a9d4fc937fb2bbf8b8b8/orig',
            ids: {},
            name: 'Афиша',
            i18nKeyName: 'afisha',
            url: 'https://afisha.yandex.ru/',
        },
        kinopoisk: {
            alias: 'kinopoisk',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/3c8752854e2d9fb4145b9a995cab8017321d774d/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/49769/e4070af0aefcd6fe2170ff14dbe5e58bad3e97d1/orig',
            ids: {},
            name: 'КиноПоиск',
            i18nKeyName: 'kinopoisk',
            url: 'https://hd.kinopoisk.ru/purchases',
        },
        plus: {
            alias: 'plus',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Плюс',
            i18nKeyName: 'plus',
        },
        help_nko: {
            alias: 'help_nko',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/b151a0f4a3796df437ebb45d913a4078289a8a7b/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/128809/6bf5ba7f303e3a6285667d61378b3133d1321a62/orig',
            ids: {},
            name: 'Помощь рядом',
            i18nKeyName: 'help_nearby',
            url: 'https://help.yandex.ru/roundup',
        },
        pay: {
            alias: 'pay',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Pay',
            i18nKeyName: 'pay',
        },
        uslugi: {
            alias: 'uslugi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/9da97fa2062af980929974de64343d47f49f72e8/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/998550/15a34c77fe975dabfe58f39f4e882d5ecc103d9e/orig',
            ids: {},
            name: 'Услуги',
            i18nKeyName: 'uslugi',
            url: 'https://uslugi.yandex.ru/my-orders',
            help: 'https://yandex.ru/chat#/user/3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        },
        lavka: {
            alias: 'lavka',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/ae04ac827389ecf6786984250872830981ca4659/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/50064/908b53b0849408ce580da95a801c9a9ee130e255/orig',
            ids: {},
            name: 'Лавка',
            i18nKeyName: 'lavka',
            url: 'https://lavka.yandex.ru',
        },
        drive: {
            alias: 'drive',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/622ce19ef4e08a91f0fe0ae410beb186e00401ba/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/942397508f0efc846b2ca05239c317ab9e7507a7/orig',
            ids: {},
            name: 'Драйв',
            i18nKeyName: 'drive',
        },
        eats: {
            alias: 'eats',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/135516/a03749b25295017394bd4c8e225cf1042d2ae1aa/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/97016dc040ed5391843ed1fd4ab6cda7c3301603/orig',
            ids: {},
            name: 'Еда',
            i18nKeyName: 'eats',
            url: 'https://eda.yandex.ru/',
        },
        taxi: {
            alias: 'taxi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/f69214ad5be2727a27383c8b25d3ec03bf783ba7/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/48f990ccafa665862e43c83ac8c965dd212d99f2/orig',
            ids: {},
            name: 'Go',
            i18nKeyName: 'taxi',
            url: 'https://go.yandex/',
        },
    },
    discounts: [
        'virtual::kinopoisk_card_discounts',
        'virtual::kinopoisk_subs_discounts',
        'virtual::new_promocode',
    ],
    servicesOrder: [
        'plus',
        'plus_360',
        'market',
        'taxi',
        'lavka',
        'eats',
        'drive',
        'refill',
        'kinopoisk',
        'afisha',
        'uslugi',
        'praktikum',
        'travel',
    ],
    plusServiceData: {
        serviceName: 'plus',
        iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
        splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
    },
};

export const test = {
    next: {
        created_keyset: 'd71357ed4319205b3036e8895b8f0d01',
        order_id_keyset: 1626888202000,
    },
    orders: [
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-20T15:01:07+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '70.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611fc3b3fbacea385e44a770',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629471676831045,
            trust_purchase_token: '0f8118ba2360f20f3350540efca8138e',
            merchant_uid: 1,
            updated: '2021-08-20T15:01:07.000+00:00',
            trust_payment_id: '611fc3b3fbacea385e44a770',
            items: [
                {
                    amount: '70.0',
                    price: '70.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-19T13:54:30+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '759.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611e629732da83bd8021e88c',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629456658663460,
            trust_purchase_token: '3a094fac82dc8343f6d8fb1c7edd8b9e',
            merchant_uid: 1,
            updated: '2021-08-19T13:54:30.000+00:00',
            trust_payment_id: '611e629732da83bd8021e88c',
            items: [
                {
                    amount: '193.0',
                    price: '193.0',
                    image_path: null,
                    name: 'Зубная паста LACALUT Multi-effect plus, 75 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '344.0',
                    price: '43.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '222.0',
                    price: '37.0',
                    image_path: null,
                    name: 'Влажные салфетки Солнце и Луна с экстрактом алоэ вера, липучка, 63 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T19:50:47+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '54.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611c13175a3951ccdfc51e46',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629229850862297,
            trust_purchase_token: 'c4f9f43383d7d320f3e2c69a1a6e29cf',
            merchant_uid: 1,
            updated: '2021-08-17T19:50:47.000+00:00',
            trust_payment_id: '611c13175a3951ccdfc51e46',
            items: [
                {
                    amount: '54.0',
                    price: '54.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-16T20:57:32+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '148.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611ad13cbed21e023d5267a8',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629147455657627,
            trust_purchase_token: 'a6b8ba785284cecf90ebca8740d6857b',
            merchant_uid: 1,
            updated: '2021-08-16T20:57:32.000+00:00',
            trust_payment_id: '611ad13cbed21e023d5267a8',
            items: [
                {
                    amount: '148.0',
                    price: '148.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-16T01:02:43+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '792.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '6119b933954f6b7a7de7e9ad',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629181632070717,
            trust_purchase_token: 'bdefc86563b8b73ed4d61f887f4e6019',
            merchant_uid: 1,
            updated: '2021-08-16T01:02:43.000+00:00',
            trust_payment_id: '6119b933954f6b7a7de7e9ad',
            items: [
                {
                    amount: '225.0',
                    price: '225.0',
                    image_path: null,
                    name: 'Салфетки спиртовые (этиловый спирт) UnicornMed 56x65 мм, 100 шт',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
                {
                    amount: '567.0',
                    price: '189.0',
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-14T18:51:19+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '60.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611810a78927ca36f55e9d29',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628967083340091,
            trust_purchase_token: '05aecca1224b22516035a78f85a28818',
            merchant_uid: 1,
            updated: '2021-08-14T18:51:19.000+00:00',
            trust_payment_id: '611810a78927ca36f55e9d29',
            items: [
                {
                    amount: '60.0',
                    price: '60.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-13T16:30:02+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '86.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '61169e0bb9f8ed363409cacb',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628872209065136,
            trust_purchase_token: '08552445c35b9e58e36835807baccd12',
            merchant_uid: 1,
            updated: '2021-08-13T16:30:02.000+00:00',
            trust_payment_id: '61169e0bb9f8ed363409cacb',
            items: [
                {
                    amount: '86.0',
                    price: '86.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-12T17:35:04+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '40.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '61155bc803c378dfafd24fc2',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628789707129510,
            trust_purchase_token: '65f3d604b3fc1d17509c949a8334ca7b',
            merchant_uid: 1,
            updated: '2021-08-12T17:35:04.000+00:00',
            trust_payment_id: '61155bc803c378dfafd24fc2',
            items: [
                {
                    amount: '40.0',
                    price: '40.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-11T01:41:41+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '1020.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '61132ad54f5c6e45669766a2',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628751314524897,
            trust_purchase_token: 'c6f5945672a5912ff6a342950e7c5def',
            merchant_uid: 1,
            updated: '2021-08-11T01:41:41.000+00:00',
            trust_payment_id: '61132ad54f5c6e45669766a2',
            items: [
                {
                    amount: '378.0',
                    price: '189.0',
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
                {
                    amount: '218.0',
                    price: '109.0',
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
                {
                    amount: '300.0',
                    price: '75.0',
                    image_path: null,
                    name: 'Жидкое мыло Невская Косметика Дегтярное для рук и тела, 300 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '124.0',
                    price: '31.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-01T14:03:41+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '16.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '6106a9bddff13b71b67f0560',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627826623945160,
            trust_purchase_token: '8e09b0dea3b5c867c255959c6b2b8f4f',
            merchant_uid: 1,
            updated: '2021-08-01T14:03:41.000+00:00',
            trust_payment_id: '6106a9bddff13b71b67f0560',
            items: [
                {
                    amount: '16.0',
                    price: '16.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-01T14:03:27+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '177.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '6106a9b003c37894964685cb',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627826611490244,
            trust_purchase_token: '7bfc5d81e303afa940fc6c1724bcafdd',
            merchant_uid: 1,
            updated: '2021-08-01T14:03:27.000+00:00',
            trust_payment_id: '6106a9b003c37894964685cb',
            items: [
                {
                    amount: '177.0',
                    price: '177.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-30T17:20:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '1931.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '610434cafbacea6381f91424',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627794199387559,
            trust_purchase_token: '47464ccff28f7e1737095514ce9930c8',
            merchant_uid: 1,
            updated: '2021-07-30T17:20:10.000+00:00',
            trust_payment_id: '610434cafbacea6381f91424',
            items: [
                {
                    amount: '1767.0',
                    price: '1767.0',
                    image_path: null,
                    name: 'Wi-Fi роутер Xiaomi Mi Wi-Fi Router 4, белый',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '164.0',
                    price: '41.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-26T15:56:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '40.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60fedb289066f416e4a386e6',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627314986199429,
            trust_purchase_token: '1d0a41b2e296efc581a7e60a83f26c82',
            merchant_uid: 1,
            updated: '2021-07-26T15:56:23.000+00:00',
            trust_payment_id: '60fedb289066f416e4a386e6',
            items: [
                {
                    amount: '40.0',
                    price: '40.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-26T13:23:05+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '182.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60feb73a03c37824ce0b738b',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627305789005492,
            trust_purchase_token: '13464e0a929c3089110e1a12ab949ea8',
            merchant_uid: 1,
            updated: '2021-07-26T13:23:05.000+00:00',
            trust_payment_id: '60feb73a03c37824ce0b738b',
            items: [
                {
                    amount: '182.0',
                    price: '182.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-26T12:28:35+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '16.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60feaa73f78dba50cf7ec6de',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627302519207222,
            trust_purchase_token: '5289e243b2e7459353ca3317783a2d4f',
            merchant_uid: 1,
            updated: '2021-07-26T12:28:35.000+00:00',
            trust_payment_id: '60feaa73f78dba50cf7ec6de',
            items: [
                {
                    amount: '16.0',
                    price: '16.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T22:15:22+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '1809.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '60fc90fa9066f44b5c74b92f',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627283918034476,
            trust_purchase_token: 'af7501b5133c9aefb663039dacc6dfcd',
            merchant_uid: 1,
            updated: '2021-07-24T22:15:22.000+00:00',
            trust_payment_id: '60fc90fa9066f44b5c74b92f',
            items: [
                {
                    amount: '954.0',
                    price: '318.0',
                    image_path: null,
                    name: 'Кофе Nescafe Classic растворимый с добавлением молотой арабики, пакет, 500 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '855.0',
                    price: '855.0',
                    image_path: null,
                    name: 'Сменные кассеты Gillette Fusion5, 4 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T21:47:55+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '656.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '60fc8a8b94d52708f6c25c2b',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627273362283977,
            trust_purchase_token: '39593697e3c134bcb6397191f0ee3fb6',
            merchant_uid: 1,
            updated: '2021-07-24T21:47:55.000+00:00',
            trust_payment_id: '60fc8a8b94d52708f6c25c2b',
            items: [
                {
                    amount: '240.0',
                    price: '30.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '198.0',
                    price: '99.0',
                    image_path: null,
                    name: 'Гречневая крупа Мистраль ядрица, 900 г',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
                {
                    amount: '218.0',
                    price: '109.0',
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T12:34:07+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '29.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60fc08c07399013ad11c51f6',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627130047678967,
            trust_purchase_token: 'e2ca9cdf92dbda3a03dc829ac27155d5',
            merchant_uid: 1,
            updated: '2021-07-24T12:34:07.000+00:00',
            trust_payment_id: '60fc08c07399013ad11c51f6',
            items: [
                {
                    amount: '29.0',
                    price: '29.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-21T17:23:56+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '18.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f8582d03c37806e5866e59',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626888236946141,
            trust_purchase_token: '480a82c053719b546213429accd8a93d',
            merchant_uid: 1,
            updated: '2021-07-21T17:23:56.000+00:00',
            trust_payment_id: '60f8582d03c37806e5866e59',
            items: [
                {
                    amount: '18.0',
                    price: '18.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-21T17:23:22+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '37.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f8580a2fe0983f8cb99c1b',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626888202575372,
            trust_purchase_token: 'd71357ed4319205b3036e8895b8f0d01',
            merchant_uid: 1,
            updated: '2021-07-21T17:23:22.000+00:00',
            trust_payment_id: '60f8580a2fe0983f8cb99c1b',
            items: [
                {
                    amount: '37.0',
                    price: '37.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
    ],
};

export const expectation = {
    edges: [
        {
            id: '1629471676831045',
            created: '2021-08-20T15:01:07+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629471676831045',
            status: 'paid',
            total: 70,
            plus: 70,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 70,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '0f8118ba2360f20f3350540efca8138e',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629456658663460',
            created: '2021-08-19T13:54:30+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '193.0',
                    price: 193,
                    image_path: null,
                    name: 'Зубная паста LACALUT Multi-effect plus, 75 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '344.0',
                    price: 344,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '222.0',
                    price: 222,
                    image_path: null,
                    name: 'Влажные салфетки Солнце и Луна с экстрактом алоэ вера, липучка, 63 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1629456658663460',
            status: 'paid',
            total: 759,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 759,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '3a094fac82dc8343f6d8fb1c7edd8b9e',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629229850862297',
            created: '2021-08-17T19:50:47+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629229850862297',
            status: 'paid',
            total: 54,
            plus: 54,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 54,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c4f9f43383d7d320f3e2c69a1a6e29cf',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629147455657627',
            created: '2021-08-16T20:57:32+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629147455657627',
            status: 'paid',
            total: 148,
            plus: 148,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 148,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'a6b8ba785284cecf90ebca8740d6857b',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629181632070717',
            created: '2021-08-16T01:02:43+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '225.0',
                    price: 225,
                    image_path: null,
                    name: 'Салфетки спиртовые (этиловый спирт) UnicornMed 56x65 мм, 100 шт',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
                {
                    amount: '567.0',
                    price: 567,
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
            ],
            orderId: '1629181632070717',
            status: 'paid',
            total: 792,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 792,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'bdefc86563b8b73ed4d61f887f4e6019',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628967083340091',
            created: '2021-08-14T18:51:19+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628967083340091',
            status: 'paid',
            total: 60,
            plus: 60,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 60,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '05aecca1224b22516035a78f85a28818',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628872209065136',
            created: '2021-08-13T16:30:02+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628872209065136',
            status: 'paid',
            total: 86,
            plus: 86,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 86,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '08552445c35b9e58e36835807baccd12',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628789707129510',
            created: '2021-08-12T17:35:04+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628789707129510',
            status: 'paid',
            total: 40,
            plus: 40,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 40,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '65f3d604b3fc1d17509c949a8334ca7b',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628751314524897',
            created: '2021-08-11T01:41:41+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '378.0',
                    price: 378,
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
                {
                    amount: '218.0',
                    price: 218,
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
                {
                    amount: '300.0',
                    price: 300,
                    image_path: null,
                    name: 'Жидкое мыло Невская Косметика Дегтярное для рук и тела, 300 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '124.0',
                    price: 124,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1628751314524897',
            status: 'paid',
            total: 1020,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1020,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c6f5945672a5912ff6a342950e7c5def',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627826623945160',
            created: '2021-08-01T14:03:41+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627826623945160',
            status: 'paid',
            total: 16,
            plus: 16,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 16,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '8e09b0dea3b5c867c255959c6b2b8f4f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627826611490244',
            created: '2021-08-01T14:03:27+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627826611490244',
            status: 'paid',
            total: 177,
            plus: 177,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 177,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '7bfc5d81e303afa940fc6c1724bcafdd',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627794199387559',
            created: '2021-07-30T17:20:10+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '1767.0',
                    price: 1767,
                    image_path: null,
                    name: 'Wi-Fi роутер Xiaomi Mi Wi-Fi Router 4, белый',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '164.0',
                    price: 164,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1627794199387559',
            status: 'paid',
            total: 1931,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1931,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '47464ccff28f7e1737095514ce9930c8',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627314986199429',
            created: '2021-07-26T15:56:23+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627314986199429',
            status: 'paid',
            total: 40,
            plus: 40,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 40,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '1d0a41b2e296efc581a7e60a83f26c82',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627305789005492',
            created: '2021-07-26T13:23:05+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627305789005492',
            status: 'paid',
            total: 182,
            plus: 182,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 182,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '13464e0a929c3089110e1a12ab949ea8',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627302519207222',
            created: '2021-07-26T12:28:35+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627302519207222',
            status: 'paid',
            total: 16,
            plus: 16,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 16,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '5289e243b2e7459353ca3317783a2d4f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627283918034476',
            created: '2021-07-24T22:15:22+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '954.0',
                    price: 954,
                    image_path: null,
                    name: 'Кофе Nescafe Classic растворимый с добавлением молотой арабики, пакет, 500 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '855.0',
                    price: 855,
                    image_path: null,
                    name: 'Сменные кассеты Gillette Fusion5, 4 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1627283918034476',
            status: 'paid',
            total: 1809,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1809,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'af7501b5133c9aefb663039dacc6dfcd',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627273362283977',
            created: '2021-07-24T21:47:55+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '240.0',
                    price: 240,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '198.0',
                    price: 198,
                    image_path: null,
                    name: 'Гречневая крупа Мистраль ядрица, 900 г',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
                {
                    amount: '218.0',
                    price: 218,
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
            ],
            orderId: '1627273362283977',
            status: 'paid',
            total: 656,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 656,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '39593697e3c134bcb6397191f0ee3fb6',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627130047678967',
            created: '2021-07-24T12:34:07+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627130047678967',
            status: 'paid',
            total: 29,
            plus: 29,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 29,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'e2ca9cdf92dbda3a03dc829ac27155d5',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626888236946141',
            created: '2021-07-21T17:23:56+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626888236946141',
            status: 'paid',
            total: 18,
            plus: 18,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 18,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '480a82c053719b546213429accd8a93d',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626888202575372',
            created: '2021-07-21T17:23:22+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626888202575372',
            status: 'paid',
            total: 37,
            plus: 37,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 37,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'd71357ed4319205b3036e8895b8f0d01',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
    ],
    pageInfo: {
        hasNextPage: true,
        startCursor: null,
        hasPreviousPage: false,
        endCursor: 'MTYyNjg4ODIwMjAwMF9fZDcxMzU3ZWQ0MzE5MjA1YjMwMzZlODg5NWI4ZjBkMDE=',
    },
};
