export const context = {
    services: {
        refill: {
            alias: 'refill',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/3b095c224131ca8faa87bfec5099a480c1fda911/svg',
            ids: {},
            name: 'Заправки',
            i18nKeyName: 'refill',
            url: 'https://zapravki.yandex.ru/',
            help: 'https://yandex.ru/chat#/user/3d8f0007-f610-914e-45f7-3eddaf3cc441',
        },
        plus_360: {
            alias: 'plus_360',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/49ef2ec62be2f58b5f765b12cdfd9a04dd826e0e/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e4a8e3d3f8810a4cbebed1fc7f8952bd5df8d870/orig',
            ids: {},
            name: 'Подписка Яндекс 360',
            i18nKeyName: 'plus_360',
            url: 'https://mail360.yandex.ru',
            help: 'https://yandex.ru/support/mail/yandex-360.html',
        },
        praktikum: {
            alias: 'praktikum',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/2029eb942ed84255579609bdd006f29bd6710d75/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/118781/57dd72c90f5871728407efd8c1e14495fee46761/orig',
            ids: {},
            name: 'Практикум',
            i18nKeyName: 'praktikum',
            url: 'https://practicum.yandex.ru/',
            help: 'https://yandex.ru/support/praktikum/feedback.html',
        },
        travel: {
            alias: 'travel',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/61205/e18dfaf6ae7e62e4a3be97bfd77e57ef33541404/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e1b838d55b6d1640a31323774f4f5a77a349766e/orig',
            ids: {},
            name: 'Путешествия',
            i18nKeyName: 'travel',
            url: 'https://travel.yandex.ru/hotels/',
            help: 'https://yandex.ru/support/travel/troubleshooting.html',
        },
        market: {
            alias: 'market',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/ae1b6a5e3bd6905ee694fedc593e6ac497fee0e2/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/35e70a852d59a7bd9c229bbf7d943f9155e65948/orig',
            ids: {},
            name: 'Маркет',
            i18nKeyName: 'market',
            url: 'https://pokupki.market.yandex.ru/my/orders',
        },
        afisha: {
            alias: 'afisha',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/128809/d4f71a94e2abd037b9e3862eca8824f6188ce7a9/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/ea8ff7736616b4920852a9d4fc937fb2bbf8b8b8/orig',
            ids: {},
            name: 'Афиша',
            i18nKeyName: 'afisha',
            url: 'https://afisha.yandex.ru/',
        },
        kinopoisk: {
            alias: 'kinopoisk',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/3c8752854e2d9fb4145b9a995cab8017321d774d/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/49769/e4070af0aefcd6fe2170ff14dbe5e58bad3e97d1/orig',
            ids: {},
            name: 'КиноПоиск',
            i18nKeyName: 'kinopoisk',
            url: 'https://hd.kinopoisk.ru/purchases',
        },
        plus: {
            alias: 'plus',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Плюс',
            i18nKeyName: 'plus',
        },
        help_nko: {
            alias: 'help_nko',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/b151a0f4a3796df437ebb45d913a4078289a8a7b/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/128809/6bf5ba7f303e3a6285667d61378b3133d1321a62/orig',
            ids: {},
            name: 'Помощь рядом',
            i18nKeyName: 'help_nearby',
            url: 'https://help.yandex.ru/roundup',
        },
        pay: {
            alias: 'pay',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Pay',
            i18nKeyName: 'pay',
        },
        uslugi: {
            alias: 'uslugi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/9da97fa2062af980929974de64343d47f49f72e8/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/998550/15a34c77fe975dabfe58f39f4e882d5ecc103d9e/orig',
            ids: {},
            name: 'Услуги',
            i18nKeyName: 'uslugi',
            url: 'https://uslugi.yandex.ru/my-orders',
            help: 'https://yandex.ru/chat#/user/3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        },
        lavka: {
            alias: 'lavka',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/ae04ac827389ecf6786984250872830981ca4659/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/50064/908b53b0849408ce580da95a801c9a9ee130e255/orig',
            ids: {},
            name: 'Лавка',
            i18nKeyName: 'lavka',
            url: 'https://lavka.yandex.ru',
        },
        drive: {
            alias: 'drive',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/622ce19ef4e08a91f0fe0ae410beb186e00401ba/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/942397508f0efc846b2ca05239c317ab9e7507a7/orig',
            ids: {},
            name: 'Драйв',
            i18nKeyName: 'drive',
        },
        eats: {
            alias: 'eats',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/135516/a03749b25295017394bd4c8e225cf1042d2ae1aa/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/97016dc040ed5391843ed1fd4ab6cda7c3301603/orig',
            ids: {},
            name: 'Еда',
            i18nKeyName: 'eats',
            url: 'https://eda.yandex.ru/',
        },
        taxi: {
            alias: 'taxi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/f69214ad5be2727a27383c8b25d3ec03bf783ba7/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/48f990ccafa665862e43c83ac8c965dd212d99f2/orig',
            ids: {},
            name: 'Go',
            i18nKeyName: 'taxi',
            url: 'https://go.yandex/',
        },
    },
    discounts: [
        'virtual::kinopoisk_card_discounts',
        'virtual::kinopoisk_subs_discounts',
        'virtual::new_promocode',
    ],
    servicesOrder: [
        'plus',
        'plus_360',
        'market',
        'taxi',
        'lavka',
        'eats',
        'drive',
        'refill',
        'kinopoisk',
        'afisha',
        'uslugi',
        'praktikum',
        'travel',
    ],
    plusServiceData: {
        serviceName: 'plus',
        iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
        splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
    },
};

export const test = {
    next: {
        created_keyset: '2a19b73cd36c061124efcd1d16009fe0',
        order_id_keyset: 1623842091000,
    },
    orders: [
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-06-16T11:14:54+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '621',
            refunds: [],
            total: '81.0',
            service_data: {
                trust_group_id: '60c9dd2c03c37819011bd689',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60c9dd2e4f5c6e7d52cd8fb1',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1623842094337590,
            trust_purchase_token: 'da3a7420d3bea14931ef858bb651c743',
            merchant_uid: 1,
            updated: '2021-06-16T11:14:54.000+00:00',
            trust_payment_id: '60c9dd2e4f5c6e7d52cd8fb1',
            items: [
                {
                    amount: '81.0',
                    price: '81.0',
                    image_path: null,
                    name: 'Оплата топлива АИ-98, Neste №300 Пулковское шоссе',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-06-16T11:14:54+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '621',
            refunds: [],
            total: '917.54',
            service_data: {
                trust_group_id: '60c9dd2c03c37819011bd689',
                cashback_amount: 0,
                user_account: '553691****8566',
                trust_payment_id: '60c9dd2e04e943fd4a0baa75',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1623842094457965,
            trust_purchase_token: 'ac5c58bce2fcccfab667b50e091373c3',
            merchant_uid: 1,
            updated: '2021-06-16T11:14:54.000+00:00',
            trust_payment_id: '60c9dd2e04e943fd4a0baa75',
            items: [
                {
                    amount: '917.54',
                    price: '917.54',
                    image_path: null,
                    name: 'Оплата топлива АИ-98, Neste №300 Пулковское шоссе',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-06-16T11:14:51+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '621',
            refunds: [],
            total: '998.54',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****8566',
                trust_payment_id: '60c9dd2c03c37819011bd689',
                payment_method: 'composite',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1623842091752658,
            trust_purchase_token: '2a19b73cd36c061124efcd1d16009fe0',
            merchant_uid: 1,
            updated: '2021-06-16T11:14:51.000+00:00',
            trust_payment_id: '60c9dd2c03c37819011bd689',
            items: [
                {
                    amount: '998.54',
                    price: '57.19',
                    image_path: null,
                    name: 'Оплата топлива АИ-98, Neste №300 Пулковское шоссе',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
    ],
};

export const expectation = {
    edges: [
        {
            id: '1623842091752658',
            created: '2021-06-16T11:14:51+00:00',
            serviceId: '621',
            refunds: [],
            items: [
                {
                    amount: '917.54',
                    price: 917.54,
                    image_path: null,
                    name: 'Оплата топлива АИ-98, Neste №300 Пулковское шоссе',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1623842091752658',
            status: 'paid',
            total: 917.54,
            plus: -81,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 81,
                    account: '',
                    currency: 'RUB',
                },
                {
                    method: 'card',
                    price: 917.54,
                    account: '553691****8566',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '2a19b73cd36c061124efcd1d16009fe0',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
    ],
    pageInfo: {
        hasNextPage: true,
        startCursor: null,
        hasPreviousPage: false,
        endCursor: 'MTYyMzg0MjA5MTAwMF9fMmExOWI3M2NkMzZjMDYxMTI0ZWZjZDFkMTYwMDlmZTA=',
    },
};
