export const context = {
    services: {
        refill: {
            alias: 'refill',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/3b095c224131ca8faa87bfec5099a480c1fda911/svg',
            ids: {},
            name: 'Заправки',
            i18nKeyName: 'refill',
            url: 'https://zapravki.yandex.ru/',
            help: 'https://yandex.ru/chat#/user/3d8f0007-f610-914e-45f7-3eddaf3cc441',
        },
        plus_360: {
            alias: 'plus_360',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/49ef2ec62be2f58b5f765b12cdfd9a04dd826e0e/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e4a8e3d3f8810a4cbebed1fc7f8952bd5df8d870/orig',
            ids: {},
            name: 'Подписка Яндекс 360',
            i18nKeyName: 'plus_360',
            url: 'https://mail360.yandex.ru',
            help: 'https://yandex.ru/support/mail/yandex-360.html',
        },
        praktikum: {
            alias: 'praktikum',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/2029eb942ed84255579609bdd006f29bd6710d75/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/118781/57dd72c90f5871728407efd8c1e14495fee46761/orig',
            ids: {},
            name: 'Практикум',
            i18nKeyName: 'praktikum',
            url: 'https://practicum.yandex.ru/',
            help: 'https://yandex.ru/support/praktikum/feedback.html',
        },
        travel: {
            alias: 'travel',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/61205/e18dfaf6ae7e62e4a3be97bfd77e57ef33541404/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e1b838d55b6d1640a31323774f4f5a77a349766e/orig',
            ids: {},
            name: 'Путешествия',
            i18nKeyName: 'travel',
            url: 'https://travel.yandex.ru/hotels/',
            help: 'https://yandex.ru/support/travel/troubleshooting.html',
        },
        market: {
            alias: 'market',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/ae1b6a5e3bd6905ee694fedc593e6ac497fee0e2/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/35e70a852d59a7bd9c229bbf7d943f9155e65948/orig',
            ids: {},
            name: 'Маркет',
            i18nKeyName: 'market',
            url: 'https://pokupki.market.yandex.ru/my/orders',
        },
        afisha: {
            alias: 'afisha',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/128809/d4f71a94e2abd037b9e3862eca8824f6188ce7a9/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/ea8ff7736616b4920852a9d4fc937fb2bbf8b8b8/orig',
            ids: {},
            name: 'Афиша',
            i18nKeyName: 'afisha',
            url: 'https://afisha.yandex.ru/',
        },
        kinopoisk: {
            alias: 'kinopoisk',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/3c8752854e2d9fb4145b9a995cab8017321d774d/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/49769/e4070af0aefcd6fe2170ff14dbe5e58bad3e97d1/orig',
            ids: {},
            name: 'КиноПоиск',
            i18nKeyName: 'kinopoisk',
            url: 'https://hd.kinopoisk.ru/purchases',
        },
        plus: {
            alias: 'plus',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Плюс',
            i18nKeyName: 'plus',
        },
        help_nko: {
            alias: 'help_nko',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/b151a0f4a3796df437ebb45d913a4078289a8a7b/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/128809/6bf5ba7f303e3a6285667d61378b3133d1321a62/orig',
            ids: {},
            name: 'Помощь рядом',
            i18nKeyName: 'help_nearby',
            url: 'https://help.yandex.ru/roundup',
        },
        pay: {
            alias: 'pay',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Pay',
            i18nKeyName: 'pay',
        },
        uslugi: {
            alias: 'uslugi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/9da97fa2062af980929974de64343d47f49f72e8/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/998550/15a34c77fe975dabfe58f39f4e882d5ecc103d9e/orig',
            ids: {},
            name: 'Услуги',
            i18nKeyName: 'uslugi',
            url: 'https://uslugi.yandex.ru/my-orders',
            help: 'https://yandex.ru/chat#/user/3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        },
        lavka: {
            alias: 'lavka',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/ae04ac827389ecf6786984250872830981ca4659/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/50064/908b53b0849408ce580da95a801c9a9ee130e255/orig',
            ids: {},
            name: 'Лавка',
            i18nKeyName: 'lavka',
            url: 'https://lavka.yandex.ru',
        },
        drive: {
            alias: 'drive',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/622ce19ef4e08a91f0fe0ae410beb186e00401ba/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/942397508f0efc846b2ca05239c317ab9e7507a7/orig',
            ids: {},
            name: 'Драйв',
            i18nKeyName: 'drive',
        },
        eats: {
            alias: 'eats',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/135516/a03749b25295017394bd4c8e225cf1042d2ae1aa/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/97016dc040ed5391843ed1fd4ab6cda7c3301603/orig',
            ids: {},
            name: 'Еда',
            i18nKeyName: 'eats',
            url: 'https://eda.yandex.ru/',
        },
        taxi: {
            alias: 'taxi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/f69214ad5be2727a27383c8b25d3ec03bf783ba7/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/48f990ccafa665862e43c83ac8c965dd212d99f2/orig',
            ids: {},
            name: 'Go',
            i18nKeyName: 'taxi',
            url: 'https://go.yandex/',
        },
    },
    discounts: [
        'virtual::kinopoisk_card_discounts',
        'virtual::kinopoisk_subs_discounts',
        'virtual::new_promocode',
    ],
    servicesOrder: [
        'plus',
        'plus_360',
        'market',
        'taxi',
        'lavka',
        'eats',
        'drive',
        'refill',
        'kinopoisk',
        'afisha',
        'uslugi',
        'praktikum',
        'travel',
    ],
    plusServiceData: {
        serviceName: 'plus',
        iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
        splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
    },
};

export const test = {
    next: {
        created_keyset: '0531a0b12239dc0dd7f82f0ccadb5769',
        order_id_keyset: 1621263895000,
    },
    orders: [
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T17:31:36+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611d43f8f98801389b5b9ae6',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629318723348965,
            trust_purchase_token: '8a0b7f8fe2e112ec7471fc1ecd916ae5',
            merchant_uid: 1,
            updated: '2021-08-18T17:31:36.000+00:00',
            trust_payment_id: '611d43f8f98801389b5b9ae6',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T17:31:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '731.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611d43eb8927ca0d0d39a604',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629307891012716,
            trust_purchase_token: '44e793c902e7ab9700d2158be0579d0f',
            merchant_uid: 1,
            updated: '2021-08-18T17:31:23.000+00:00',
            trust_payment_id: '611d43eb8927ca0d0d39a604',
            items: [
                {
                    amount: '731.0',
                    price: '731.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:42+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '69.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611cc802f9880122995b9bc3',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629276166456154,
            trust_purchase_token: 'd18fdf4a326baab6a1a874997b0d325f',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:42.000+00:00',
            trust_payment_id: '611cc802f9880122995b9bc3',
            items: [
                {
                    amount: '69.0',
                    price: '69.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:30+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '35.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611cc7f699d6ef1d232f7325',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629276153418761,
            trust_purchase_token: 'a78303a1d2dde98520d7170e5f5d1d57',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:30.000+00:00',
            trust_payment_id: '611cc7f699d6ef1d232f7325',
            items: [
                {
                    amount: '35.0',
                    price: '35.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:15+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '684.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611cc7e7bed21e3abd3e1fb7',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629286963224423,
            trust_purchase_token: '0f50d239c3ee46c044bffb806bc6948e',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:15.000+00:00',
            trust_payment_id: '611cc7e7bed21e3abd3e1fb7',
            items: [
                {
                    amount: '684.0',
                    price: '684.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T19:30:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '20.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611c0e42954f6b3d921bc9a1',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629239428546569,
            trust_purchase_token: 'fec8db735204c5af5469101699461603',
            merchant_uid: 1,
            updated: '2021-08-17T19:30:10.000+00:00',
            trust_payment_id: '611c0e42954f6b3d921bc9a1',
            items: [
                {
                    amount: '20.0',
                    price: '20.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'tip',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T15:04:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611bcff7c3080fa44323683e',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629223480094535,
            trust_purchase_token: '2718dc054375f9d0178dfe0610736287',
            merchant_uid: 1,
            updated: '2021-08-17T15:04:23.000+00:00',
            trust_payment_id: '611bcff7c3080fa44323683e',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T15:04:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '398.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611bcfea8927ca24e139a62f',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629212656292950,
            trust_purchase_token: 'c63efed7f286da78c3659f08aeb7c40a',
            merchant_uid: 1,
            updated: '2021-08-17T15:04:10.000+00:00',
            trust_payment_id: '611bcfea8927ca24e139a62f',
            items: [
                {
                    amount: '398.0',
                    price: '398.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-26T14:41:35+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '60ae5e2020d51d0608181016',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1622040095978914,
            trust_purchase_token: 'f8a70a9313a5c03554b4328821971273',
            merchant_uid: 1,
            updated: '2021-05-26T14:41:35.000+00:00',
            trust_payment_id: '60ae5e2020d51d0608181016',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-26T14:41:24+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '402.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60ae5e147153b30d96fe755c',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1622040085017651,
            trust_purchase_token: '130d603173646caac040b300bdfd3920',
            merchant_uid: 1,
            updated: '2021-05-26T14:41:24.000+00:00',
            trust_payment_id: '60ae5e147153b30d96fe755c',
            items: [
                {
                    amount: '402.0',
                    price: '402.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-26T13:46:22+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '88.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60ae512edff13b0d4c9c977b',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1622036782068354,
            trust_purchase_token: '845e757223403f4952289d1f8cfdf1c4',
            merchant_uid: 1,
            updated: '2021-05-26T13:46:22.000+00:00',
            trust_payment_id: '60ae512edff13b0d4c9c977b',
            items: [
                {
                    amount: '88.0',
                    price: '88.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-26T13:46:08+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '875.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '60ae5120c5311b66dcd39503',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1622036768386620,
            trust_purchase_token: '4ad32d288384a34594ddf982e7188b0c',
            merchant_uid: 1,
            updated: '2021-05-26T13:46:08.000+00:00',
            trust_payment_id: '60ae5120c5311b66dcd39503',
            items: [
                {
                    amount: '875.0',
                    price: '875.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-26T12:35:46+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '60ae40a27153b31be09774b2',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1622032546340151,
            trust_purchase_token: 'cdc59812032ce4fec5b3c8083b4d5415',
            merchant_uid: 1,
            updated: '2021-05-26T12:35:46.000+00:00',
            trust_payment_id: '60ae40a27153b31be09774b2',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-26T12:35:34+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '471.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60ae40969066f4788dfa5dec',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1622032534133371,
            trust_purchase_token: '7c35fe37d2ac6b380093d288f1e4409d',
            merchant_uid: 1,
            updated: '2021-05-26T12:35:34.000+00:00',
            trust_payment_id: '60ae40969066f4788dfa5dec',
            items: [
                {
                    amount: '471.0',
                    price: '471.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-22T14:14:11+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '60a911b303c378b0521ae819',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1621692851014001,
            trust_purchase_token: '3c4fafade2a4eb81350e7a94d55975ac',
            merchant_uid: 1,
            updated: '2021-05-22T14:14:11.000+00:00',
            trust_payment_id: '60a911b303c378b0521ae819',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_18',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-22T14:13:59+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '375.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60a911a84f5c6e5591618ffa',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1621692839131478,
            trust_purchase_token: '9236023cf375c52013bd7f134bf9e7af',
            merchant_uid: 1,
            updated: '2021-05-22T14:13:59.000+00:00',
            trust_payment_id: '60a911a84f5c6e5591618ffa',
            items: [
                {
                    amount: '375.0',
                    price: '375.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_18',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-17T16:16:09+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '60a296c94f5c6e0ba970c114',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1621268169339634,
            trust_purchase_token: '97c255db23270b1e37f2798fa36011c2',
            merchant_uid: 1,
            updated: '2021-05-17T16:16:09.000+00:00',
            trust_payment_id: '60a296c94f5c6e0ba970c114',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_18',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-17T16:15:57+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '152.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60a296bd03c3789e43067de9',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1621268157784006,
            trust_purchase_token: '13a9598232fd1f4612b82f15ecdc1beb',
            merchant_uid: 1,
            updated: '2021-05-17T16:15:57.000+00:00',
            trust_payment_id: '60a296bd03c3789e43067de9',
            items: [
                {
                    amount: '152.0',
                    price: '152.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_18',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-17T15:05:09+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '20.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60a28625dff13b4b4cd94654',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1621263909338764,
            trust_purchase_token: '2b091f6b83c995273020419aff86c5c3',
            merchant_uid: 1,
            updated: '2021-05-17T15:05:09.000+00:00',
            trust_payment_id: '60a28625dff13b4b4cd94654',
            items: [
                {
                    amount: '20.0',
                    price: '20.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-05-17T15:04:55+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '193.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '60a2861803c3784022067d56',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1621263895946951,
            trust_purchase_token: '0531a0b12239dc0dd7f82f0ccadb5769',
            merchant_uid: 1,
            updated: '2021-05-17T15:04:55.000+00:00',
            trust_payment_id: '60a2861803c3784022067d56',
            items: [
                {
                    amount: '193.0',
                    price: '193.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
    ],
};

export const expectation = {
    edges: [
        {
            id: '1629318723348965',
            created: '2021-08-18T17:31:36+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629318723348965',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '8a0b7f8fe2e112ec7471fc1ecd916ae5',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629307891012716',
            created: '2021-08-18T17:31:23+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629307891012716',
            status: 'paid',
            total: 0,
            plus: -731,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 731,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '44e793c902e7ab9700d2158be0579d0f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629276166456154',
            created: '2021-08-18T08:42:42+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629276166456154',
            status: 'paid',
            total: 69,
            plus: 69,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 69,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'd18fdf4a326baab6a1a874997b0d325f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629276153418761',
            created: '2021-08-18T08:42:30+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629276153418761',
            status: 'paid',
            total: 35,
            plus: 35,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 35,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'a78303a1d2dde98520d7170e5f5d1d57',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629286963224423',
            created: '2021-08-18T08:42:15+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '684.0',
                    price: 684,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629286963224423',
            status: 'paid',
            total: 684,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 684,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '0f50d239c3ee46c044bffb806bc6948e',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629239428546569',
            created: '2021-08-17T19:30:10+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '20.0',
                    price: 20,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'tip',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629239428546569',
            status: 'paid',
            total: 20,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 20,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'fec8db735204c5af5469101699461603',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629223480094535',
            created: '2021-08-17T15:04:23+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629223480094535',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '2718dc054375f9d0178dfe0610736287',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629212656292950',
            created: '2021-08-17T15:04:10+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629212656292950',
            status: 'paid',
            total: 0,
            plus: -398,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 398,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c63efed7f286da78c3659f08aeb7c40a',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1622040095978914',
            created: '2021-05-26T14:41:35+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1622040095978914',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'f8a70a9313a5c03554b4328821971273',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1622040085017651',
            created: '2021-05-26T14:41:24+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1622040085017651',
            status: 'paid',
            total: 0,
            plus: -402,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 402,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '130d603173646caac040b300bdfd3920',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1622036782068354',
            created: '2021-05-26T13:46:22+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1622036782068354',
            status: 'paid',
            total: 88,
            plus: 88,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 88,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '845e757223403f4952289d1f8cfdf1c4',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1622036768386620',
            created: '2021-05-26T13:46:08+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '875.0',
                    price: 875,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1622036768386620',
            status: 'paid',
            total: 875,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 875,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '4ad32d288384a34594ddf982e7188b0c',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1622032546340151',
            created: '2021-05-26T12:35:46+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1622032546340151',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'cdc59812032ce4fec5b3c8083b4d5415',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1622032534133371',
            created: '2021-05-26T12:35:34+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1622032534133371',
            status: 'paid',
            total: 0,
            plus: -471,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 471,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '7c35fe37d2ac6b380093d288f1e4409d',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1621692851014001',
            created: '2021-05-22T14:14:11+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_18',
                    hidden: false,
                },
            ],
            orderId: '1621692851014001',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '3c4fafade2a4eb81350e7a94d55975ac',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1621692839131478',
            created: '2021-05-22T14:13:59+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1621692839131478',
            status: 'paid',
            total: 0,
            plus: -375,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 375,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '9236023cf375c52013bd7f134bf9e7af',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1621268169339634',
            created: '2021-05-17T16:16:09+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_18',
                    hidden: false,
                },
            ],
            orderId: '1621268169339634',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '97c255db23270b1e37f2798fa36011c2',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1621268157784006',
            created: '2021-05-17T16:15:57+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1621268157784006',
            status: 'paid',
            total: 0,
            plus: -152,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 152,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '13a9598232fd1f4612b82f15ecdc1beb',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1621263909338764',
            created: '2021-05-17T15:05:09+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1621263909338764',
            status: 'paid',
            total: 20,
            plus: 20,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 20,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '2b091f6b83c995273020419aff86c5c3',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1621263895946951',
            created: '2021-05-17T15:04:55+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '193.0',
                    price: 193,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1621263895946951',
            status: 'paid',
            total: 193,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 193,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '0531a0b12239dc0dd7f82f0ccadb5769',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
    ],
    pageInfo: {
        hasNextPage: true,
        startCursor: null,
        hasPreviousPage: false,
        endCursor: 'MTYyMTI2Mzg5NTAwMF9fMDUzMWEwYjEyMjM5ZGMwZGQ3ZjgyZjBjY2FkYjU3Njk=',
    },
};
